; 	INTEGER FUNCTION PS_LENGTH(SIZE,STRING,FONT,POINTS,ADJUST)    **B *	INTEGER FUNCTION PS_LENGTH( size, string, font, points, adjust ) *  * D *	Computes the  displayed length of  STRING  if it  were rendered inD *	PostScript font FONT in point size POINTS with ADJUST extra pointsD *	of spacing added to every blank.  The length is returned in varia-D *	ble SIZE.  Variables SIZE, POINTS, and ADJUST are REAL.  ADJUST is *	normally zero. * A *	Example:  ISTAT = PS_LENGTH(SZ,'Hello','Helvetica-Bold',14.,0.)  * D *	The length is computed  using the font metrics stored in text lib-D *	rary  SYS$LIBRARY:LPS$FONT_METRICS.TLB.   The function result is 1D *	unless an error has occurred; 2 means the text library couldn't beD *	opened, 4 means the font was not in the library (you possibly mis-D *	spelled the font name), 6 means the font metrics were invalid (re-$ *	port this to your system manager). *  * < *	25 Sep 1991	Close the text library after metrics obtained. *  *	.INDEX STRING MANIPULATION>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55 * *	19 Sep 1991	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	REAL*4 SIZE,POINTS,ADJUST 	CHARACTER*(*) STRING,FONT  " 	INTEGER*4 METRIC(0:255) / 256*0 /  " 	CHARACTER*64 FONT_ / ' ' /,FONT__ 	CHARACTER*256 LINE 1 	INTEGER*4 COL,COL2,I,LINDEX /0/,LLEN,M,N,NBLANKS = 	INTEGER*4 STATUS,GET_TEXT_LIB,GET_TEXT_LIB_DATA,OTS$CVT_TI_L    	IF (FONT.EQ.FONT__) GO TO 50   5 *	Get the correct font name as stored in the library.    	FONT_  = FONT 	FONT__ = FONT 	LLEN = LEN(FONT)    	DO I = 1, LLEN A 	    IF (FONT_(I:I).EQ.' '.OR.FONT_(I:I).EQ.'-') FONT_(I:I) = '_'  	ENDDO  1 *	Get the metrics for each character of the font.  	 A 	PS_LENGTH =GET_TEXT_LIB(LINDEX,'LPS$FONT_METRICS',FONT_(1:LLEN))    	IF (.NOT.PS_LENGTH) THEN  	    FONT_ = ' ' 	    RETURN  	ENDIF  : 10	IF (.NOT.GET_TEXT_LIB_DATA(LINDEX,LINE,LLEN)) GO TO 100  0 	IF (LINE(1:17).NE.'StartCharMetrics ') GO TO 10  I 	IF (.NOT.OTS$CVT_TI_L(LINE(18:LLEN),N)) GO TO 100   ! No. of CharMetrics $ 	IF (N.LE.0 .OR. N.GT.512) GO TO 100   	DO I = 1, N  < 	    IF (.NOT.GET_TEXT_LIB_DATA(LINDEX,LINE,LLEN)) GO TO 1001 	    IF (LINE(1:2).NE.'C ') GO TO 100			! Ordinal   " 	    COL = INDEX(LINE(1:LLEN),';') 	    IF (COL.EQ.0) GO TO 100  6 	    IF (.NOT.OTS$CVT_TI_L(LINE(3:COL-2),M)) GO TO 100 	    IF (M.EQ.-1) GO TO 20) 	    IF (M.LE.0 .OR. M.GT.255) GO TO 100	   : 	    IF (LINE(COL+1:COL+4).NE.' WX ') GO TO 100		! X width  ' 	    COL2 = INDEX(LINE(COL+1:LLEN),';')  	    IF (COL2.EQ.0) GO TO 100    	    COL2 = COL2 + COL 	     9 	    IF (.NOT.OTS$CVT_TI_L(LINE(COL+5:COL2-2),METRIC(M)))  	1						       GO TO 100" 	    IF (METRIC(M).LE.0) GO TO 100   20	ENDDO   	CALL LBR$CLOSE(LINDEX)    50	M = 0 	NBLANKS = 0   	LLEN = LEN(STRING)  	IF (LLEN.EQ.0) GO TO 60   	DO I = 1, LLEN  	    N = ICHAR(STRING(I:I))  	    M = M + METRIC(N)< 	    IF (N.EQ.32) NBLANKS = NBLANKS + 1		! ASCII BLANK is 32 	ENDDO  8 60	SIZE = FLOAT(M) * POINTS / 1000. + (NBLANKS * ADJUST)   	PS_LENGTH = 1 	RETURN    100	PS_LENGTH = 6   
 	END									   : 	INTEGER FUNCTION GET_TEXT_LIB(INDEX,LIBRARY,ELEMENT_NAME)   **A *	INTEGER FUNCTION GET_TEXT_LIB( index , library , element_name )  *  * D *	Opens a text library and locates a module in the library.   Subse-D *	quent calls to routine GET_TEXT_LIB_DATA will each read one record *	of text from this module.  * D *	INDEX must be an INTEGER*4 variable where  GET_TEXT_LIB will storeD *	context information; several libraries may be open at once if sep-D *	arate context  variables are used.   Character string LIBRARY mustD *	contain the library file name  (the default device is SYS$LIBRARY:D *	and the default file type is .TLB).  Character string ELEMENT_NAME1 *	must be the name of the desired library module.  * C *	Example:  ISTAT = GET_TEXT_LIB(IX,'LPS$FONT_METRICS','HELVETICA')  * D *	The function result is 1 unless an error has occurred; 2 means theD *	text library couldn't  be found or opened,  4 means the module was *	not found in the library.  *  *	.INDEX STRING MANIPULATION>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55 * *	19 Sep 1991	   Dahlgren, Virginia  22448 *    	IMPLICIT NONE   	INTEGER*4 INDEX# 	CHARACTER*(*) LIBRARY,ELEMENT_NAME   1 	INTEGER*4 GET_TEXT_LIB_DATA	! Second entry point  	CHARACTER*(*) LINE  	INTEGER*4 LLEN    	INCLUDE '($LBRDEF)'  * 	EXTERNAL LBR$_KEYNOTFND,RMS$_EOF,RMS$_FNF  4 	INTEGER*4 DESCR(2),STATUS,LBR$INI_CONTROL,LBR$OPEN,- 	1			 LBR$LOOKUP_KEY,LBR$GET_RECORD,LBR$CLOSE    	GET_TEXT_LIB = 1   9 	STATUS = LBR$INI_CONTROL(INDEX,LBR$C_READ,LBR$C_TYP_TXT) 0 	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	  5 	STATUS = LBR$OPEN(INDEX,LIBRARY,,'SYS$LIBRARY:.TLB')  	  IF (.NOT.STATUS) THEN) 	      IF (STATUS.NE.%LOC(RMS$_FNF)) THEN   		  CALL LIB$STOP(%VAL(STATUS))	 	      ELSE & 		  GET_TEXT_LIB = 2	! No such library
 		  RETURN 	      ENDIF 	  ENDIF    2 	STATUS = LBR$LOOKUP_KEY(INDEX,ELEMENT_NAME,DESCR) 	  IF (.NOT.STATUS) THEN/ 	      IF (STATUS.NE.%LOC(LBR$_KEYNOTFND)) THEN   		  CALL LIB$STOP(%VAL(STATUS))	 	      ELSE & 		  GET_TEXT_LIB = 4	! No such element
 		  GO TO 100  	      ENDIF 	  ENDIF   	RETURN       ) 	ENTRY GET_TEXT_LIB_DATA(INDEX,LINE,LLEN)    **; *	INTEGER FUNCTION GET_TEXT_LIB_DATA( index , line , llen )  *  * D *	Returns one record of text  from the text library module opened byD *	a previous call to GET_TEXT_LIB.   Variable INDEX must be the sameD *	context variable specified to  GET_TEXT_LIB.   The contents of theD *	record  are returned  in character string  LINE,  and the count of: *	characters returned in LINE is returned in integer LLEN. * E *	The function result is .TRUE. unless there was no record to return, D *	in which case the  function result is .FALSE. and the text library *	is closed. *  *	.INDEX STRING MANIPULATION>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55 * *	19 Sep 1991	   Dahlgren, Virginia  22448 *   5 	GET_TEXT_LIB_DATA = LBR$GET_RECORD(INDEX,LINE,DESCR) # 	  IF (.NOT.GET_TEXT_LIB_DATA) THEN 9 	      IF (GET_TEXT_LIB_DATA.EQ.%LOC(RMS$_EOF)) GO TO 100 " 	      CALL LIB$STOP(%VAL(STATUS)) 	  ENDIF   	LLEN = DESCR(1)   	RETURN    100	STATUS = LBR$CLOSE(INDEX) 0 	  IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	  
 	END									 