
#include <descrip.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

#include <climsgdef.h>
#include <clidef.h>
#include <lib$routines.h>
#include <str$routines.h>
#include <starlet.h>
#include <ctype.h>
#include "loop_msg.h"

#ifdef __GNUC__
#define cli$present   CLI$PRESENT
#define cli$dcl_parse CLI$DCL_PARSE
#define cli$get_value CLI$GET_VALUE
#else
#include <libclidef.h>
#endif

#ifdef __ALPHA
#include <cli$routines.h>
#endif

#if defined(__DECC) || defined(__GNUC__)
#   include <unixlib.h>
#endif


#define LONG	255
#define DIM	20
#define VERSION "V02.170"
#define COPYR	"Copyright  1994-1999 Jrme LAURET"

#ifndef TRUE
#define TRUE (1==1)
#define FALSE (1==0)
#endif

#define ESC "\033"


/* Command line								*/
char    cmds[LONG]							;
char	command[DIM][LONG]						;


/* Default global values 						*/

GLOBALDEF(int,debug,FALSE)						;
GLOBALDEF(int,dolog,TRUE)						;
GLOBALDEF(int,doech,0)							;

int     time=30							        ;
int	modulo= -1							;
int	dodir=1							        ;
int	cls=FALSE							;
int	shv=FALSE							;
int	leave=TRUE							;
int	mode								;
int	max								;
long	count								;
char	*flnm								;



/* Macro def								*/
#define clear() printf("%s[H%s[2J\n",ESC,ESC)
#define OK(s)	$VMS_STATUS_SUCCESS(s)


/* Function declaration 						*/
void    get_args(void)							;
void	exit_lhelp(int)						        ;
void	strtrim(char *)						        ;
void	action(char *)							;
void	check_next_loop(int *)						;
unsigned int CLI_GET_VALUE(char *,char *)				;
unsigned int CLI_PRESENT()						;





int main(int argc,char **argv)
{
char    *ptr,*start							;
char	buffer[LONG]							;
int	j,i								;



    /* Look for NO Argument		*/
    if(argc == 1){
	exit_lhelp(-1)							;
	hack$exit(LOOP__NOCMD_msg_hack)				        ;
    }

    hack$establish(lib$sig_to_ret)					;
    get_args()								;
    hack$revert()							;

    /* Leave if version only is required				*/
    if( shv ){
	hack$signal(LOOP__VERSION_msg_hack,2,VERSION,COPYR)		;
	exit(SS$_NORMAL)						;
    }


    /* Set default values 						*/
    if( time == 0){
	hack$signal(LOOP__NULLVAL_msg_hack,2,"EVERY",30)		;
	time = 30							;
    }
    if( modulo == 0){
	hack$signal(LOOP__NULLVAL_msg_hack,2,"MAX",1)			;
	modulo = 1							;
    }
    if(debug) doech = TRUE						;


    if(debug){
     if(mode == 0){
	sprintf(buffer,"Command Mode   :: Time=%d Modulo=%d Clear=%d %s",
			time,modulo,cls,cmds)				;
	hack$signal(LOOP__DEBUG_msg_hack,1,buffer)			;
     } else {
	sprintf(buffer,"File mode used :: Use.Dir=%d Files=%s",dodir,flnm);
	hack$signal(LOOP__DEBUG_msg_hack,1,buffer)			;
     }
    }


    /* Scan cmds and cut/paste into an array of commands		*/
    i = 0								;
    for( start = ptr = cmds ; *ptr ; ptr++){
	if ( *ptr == '+' ){
		*ptr++ = '\0'						;
		if( strlen(start) <= (LONG-3))
			strcpy(command[i],start)			;
		else	hack$signal(LOOP__TOOLONG_msg_hack,1,start)	;
		strtrim(command[i])					;
		if( command[i][0] != '\0') i++				;
		start = ptr						;
	}
    }
    max = i								;

    /* The -3 is so that I do not have to re-check later for "%s"	*/
    if( strlen(start) <= (LONG-3))
    		strcpy(command[i],start)				;
    else	hack$signal(LOOP__TOOLONG_msg_hack,1,start)		;
    strtrim(command[i])						        ;
    if( command[i][0] == '\0') max--					;



    /* Debugging							*/
    if(debug)
     for(i =0 ; i <= max ; i++){
	sprintf(buffer,"Command %4d :: [%s]",i,command[i])		;
	hack$signal(LOOP__DEBUG_msg_hack,1,buffer)			;
     }


    /* Execute commands. 2 modes					*/
    j = modulo								;
    if(mode == 0){
     /* Command repetition mode						*/
     while(j != 0){
	if(cls) clear()						        ;
	for(i = 0 ; i <= max ; i++){
		if(! i )printf("\n")					;
		if(doech) hack$signal(LOOP__EXEC_msg_hack,2,i+1,command[i]);
		(void) system(command[i])				;
    	}
	check_next_loop(&j)						;
     }
    } else {
     /* File scan mode							*/
     unsigned int	len						;
     unsigned int	status						;
     unsigned long	context=0					;
     int		cutwld;
     char		next_file[LONG]="\0"				;
     char		wild_file[LONG]="\0"				;
     char		*qw;

     $DESCRIPTOR(next_file_d,next_file)				        ;
     $DESCRIPTOR(wild_file_d,wild_file)				        ;

     while(j != 0){
      if(cls) clear()							;
      count=0								;

      /* Get the "%" lowercased						*/
      for (i = 0 ; i <= max ; i++){
	ptr = strchr(command[i],'%')					;
	if(ptr){
	 for ( start = ptr ; (*start != ' ') && (*start != '\011') ; start++){
		*start = tolower(*start)				;
	 }
	} else {
	 strcat(command[i]," %s")					;
	}
      }

      /* Call the wildcard stuff					*/
      start = ptr = flnm						;
      ptr   = strchr(start,',')					        ;
      do{
	if(ptr) *ptr++	= '\0'						;

	if(debug){
		sprintf(buffer,"Calling file locator with %s",start)	;
		hack$signal(LOOP__DEBUG_msg_hack,1,buffer)		;
	}

	strcpy(wild_file,start)					        ;

	/* Check if the file name had a version wildcard		*/
	len	= strlen(wild_file)					;
	if(  (wild_file[len-2] == ';' && wild_file[len-1] == '*') ||
	     (wild_file[len-1] == ';')){
		cutwld	= FALSE						;
	} else {
		cutwld	= TRUE;
	}

        wild_file_d.dsc$w_length = strlen(wild_file)			;
        wild_file_d.dsc$a_pointer= (void *) wild_file			;
        wild_file_d.dsc$b_class  = DSC$K_CLASS_S			;
        wild_file_d.dsc$b_dtype  = DSC$K_DTYPE_T			;
	NEXT_FILE:
	  status = lib$find_file(&wild_file_d,&next_file_d,&context,0,0,0,0);
	  if( OK(status) ){
		strtrim(next_file)					;
		if( (strstr(next_file,".DIR") != '\0') && (! dodir)){
			if(doech) hack$signal(LOOP__IGNORE_msg_hack,1,next_file);
		} else {
			if(cutwld){
			 /* Well, input was not a wildcard, output is 	*/
			 /* so fix it ...				*/
			 qw	= strchr(next_file,';');
			 *qw	= '\0';
			}
			action(next_file)				;
		}
		goto NEXT_FILE						;
	  }
        lib$find_file_end(&context)					;

	start	= ptr							;
	if(start) ptr	= strchr(start,',')				;
      } while(start)							;
      if(count == 0){
	if(leave){
		hack$exit(LOOP__NOSELX_msg_hack)			;
	} else {
		hack$signal(LOOP__NOSEL_msg_hack)			;
	}
      }
      check_next_loop(&j)						;
     }
    }

    return(SS$_NORMAL)							;
}


void	action(char *file)
{
int	i								;

	if(debug)	hack$signal(LOOP__DEBUG_msg_hack,1,file)	;

	for(i = 0 ; i <= max ; i++){
		sprintf(cmds,command[i],file)				;
		if(doech) hack$signal(LOOP__EXEC_msg_hack,2,i+1,cmds)	;
		(void) system(cmds)					;
    	}
	count++							        ;
}


void	strtrim(char *c1)
{
char	*c3								;
int	len=strlen(c1)							;
char	*ad,*dep							;
int	pos,i								;

	if( (c3 = (char *) malloc(len)) == NULL) hack$exit(LOOP__INSFMEM_msg_hack);
	ad = c3							        ;
	dep= c1							        ;

	/* Advance pointer c1 to the first non-space character		*/
	for( ; *c1 ; c1++ )
		if (	*c1 != '\011' 	&&	*c1 != '\012'	&&
			*c1 != '\013'	&&	*c1 != '\014'	&&
			*c1 != '\015'	&&	*c1 != ' '	) break ;


	/* copy/shift the no-blank character. Count length		*/
	for( i=0; *c1 ; c1++,i++){
		if (	*c1 != '\011' 	&&	*c1 != '\012'	&&
			*c1 != '\013'	&&	*c1 != '\014'	&&
			*c1 != '\015'	&&	*c1 != ' '	) pos = i;
		*c3 = *c1						;
		c3++							;
	}

	/* Fix/Restore							*/
	c3		= ad						;
	c3[pos+1]	= '\0'						;
	c1		= dep						;
	strcpy(c1,c3)							;
	free(c3)							;
}


void	check_next_loop(int *j)
{
 if(dolog){
	unsigned long  int curtime[2]					;
	unsigned short int timlen					;
	char	curtime_str[40]="\0"					;

	$DESCRIPTOR(curtime_str_d, curtime_str)			        ;

	sys$gettim(curtime)						;
	sys$asctim(&timlen, &curtime_str_d, curtime, 0)		        ;
	curtime_str[timlen] = '\0'					;
	printf("\n %s[7m %s - LOOP %s - #%d  (modulo=%d scdes)%s[0m\n"
		,ESC, curtime_str,VERSION,modulo-(*j)+1,time, ESC)	;
 }
 (*j)--								        ;
 if(*j != 0)	sleep(time)						;
}


void get_args(void)
{
unsigned int    status							;
char what[LONG]							        ;

#if defined(__DECC) || defined(__GNUC__)
extern char     *LOOP							;
#else
globalref       LOOP							;
#endif

struct dsc$descriptor line_str_d={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0}	;
$DESCRIPTOR(Command,"LOOP ")						;
$DESCRIPTOR(ligne_d,"LIGNE")						;

        lib$get_foreign(&line_str_d)					;
        str$concat(&line_str_d,&Command,&line_str_d)			;
        status = cli$dcl_parse(&line_str_d,&LOOP)			;
        if (!(status & 1))exit(status)					;


	/* Genaral qualifiers						*/
        if( CLI_PRESENT("HELP") == CLI$_PRESENT) exit_lhelp(SS$_NORMAL) ;
        if( CLI_PRESENT("VERSION") == CLI$_PRESENT) shv = TRUE		;

        status = CLI_PRESENT("LOGCNT")					;
        if( status == CLI$_PRESENT)     dolog   = TRUE			;
        if( status == CLI$_NEGATED)     dolog   = FALSE		        ;

        status = CLI_PRESENT("ECHO")					;
        if( status == CLI$_PRESENT)     doech	= TRUE			;
        if( status == CLI$_NEGATED)     doech	= FALSE		        ;

        status = CLI_PRESENT("DEBUG")					;
        if( status == CLI$_PRESENT)     debug	= TRUE			;
        if( status == CLI$_NEGATED)     debug	= FALSE		        ;


	/* Those are /onfile related					*/
        status = CLI_PRESENT("LEAVE")					;
        if( status == CLI$_PRESENT)     leave	= TRUE			;
        if( status == CLI$_NEGATED)     leave	= FALSE		        ;



	/* Those are /repeat related					*/
	if( OK(CLI_GET_VALUE("EVERY",what)) )
					time	= atoi(what)		;

	if( OK(CLI_GET_VALUE("MAX",what)) )
					modulo	= atoi(what)		;

        status = CLI_PRESENT("CLEAR")					;
        if( status == CLI$_PRESENT)     cls	= TRUE			;
        if( status == CLI$_NEGATED)     cls	= FALSE		        ;


	/* Those are /onfile related					*/
        status = CLI_PRESENT("DIRECTORY")				;
        if( status == CLI$_PRESENT)     dodir	= 1			;
        if( status == CLI$_NEGATED)     dodir	= 0			;

        if( ! OK( cli$get_value(&ligne_d,&line_str_d) ) ){
         if( ! shv ) hack$exit(LOOP__NOCMD_msg_hack)			;
        } else {
         strncpy(cmds,line_str_d.dsc$a_pointer,line_str_d.dsc$w_length) ;
         cmds[line_str_d.dsc$w_length] = '\0'				;
        }

	/* 2 possible modes 						*/
	if( OK(CLI_GET_VALUE("ONFILE",what)) ){
		mode	= 1						;
		if(modulo==0) modulo	= 1				;
		flnm	= (char *) malloc(sizeof(what))		        ;
		if( flnm == NULL ) hack$exit(LOOP__INSFMEM_msg_hack)	;
		strcpy(flnm,what)					;
		while( OK(CLI_GET_VALUE("ONFILE",what)) ){
			flnm	= (char *) realloc( (void *) flnm,sizeof(what)+1);
			if( flnm == NULL) hack$exit(LOOP__INSFMEM_msg_hack);
			strcat(flnm,",")				;
			strcat(flnm,what)				;
		}
	}

        status = CLI_PRESENT("REPEAT")					;
        if( status == CLI$_PRESENT){
		mode	= 0						;
	}

	/* /QUIT is really a short-cut for /MAX=1			*/
        status = CLI_PRESENT("QUIT")					;
	if( status == CLI$_PRESENT )	modulo	= 1			;
}


unsigned int CLI_GET_VALUE (char *item, char *retv) {
struct dsc$descriptor item_d={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0}		;
struct dsc$descriptor retv_d={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0}		;
unsigned int status							;

	item_d.dsc$w_length = strlen(item)				;
	item_d.dsc$a_pointer= (void *) item				;
	item_d.dsc$b_class  = DSC$K_CLASS_S				;
	item_d.dsc$b_dtype  = DSC$K_DTYPE_T				;

	status = cli$present(&item_d)					;
	if ( OK(status) ) {
		status = cli$get_value(&item_d, &retv_d)		;
		if (OK(status)){
			strncpy(retv,retv_d.dsc$a_pointer,retv_d.dsc$w_length);
			*(retv+retv_d.dsc$w_length) = '\0'		;
		}
	}
	return status							;
}





unsigned int CLI_PRESENT(char *item)
{
struct dsc$descriptor item_d={0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0}		;

        item_d.dsc$w_length = strlen(item)				;
        item_d.dsc$a_pointer= (void *) item				;
        item_d.dsc$b_class  = DSC$K_CLASS_S				;
        item_d.dsc$b_dtype  = DSC$K_DTYPE_T				;
        return cli$present(&item_d)					;
}


void exit_lhelp(int sts)
{
 printf("\nLOOP version %s %s\n",VERSION,COPYR)			        ;
#include "loop_help.c"
 if(sts != -1) exit(sts)						;
}



