
#ifndef ssl_criteria_h_
#define ssl_criteria_h_

/********************************************************************/
/* data types                                                       */
/********************************************************************/

struct ssl_criteria_node;

enum ssl_criteria_node_type {
    SSL_CRITERIA_AND,
    SSL_CRITERIA_OR,
    SSL_CRITERIA_UNARY,
    SSL_CRITERIA_PRIMITIVE,
};

enum ssl_criteria_unary_type {
    SSL_CRITERIA_NOT,
    SSL_CRITERIA_DEPTH,
};

enum ssl_criteria_primitive_type {
    SSL_CRITERIA_COMMON_NAME,
    SSL_CRITERIA_COUNTRY_NAME,
    SSL_CRITERIA_STATE_NAME,
    SSL_CRITERIA_LOCALITY_NAME,
    SSL_CRITERIA_ORGANIZATION_NAME,
    SSL_CRITERIA_DEPARTMENT_NAME,
    SSL_CRITERIA_PUBKEY_MATCH_CERT,
    SSL_CRITERIA_CERT_DIGEST,
    SSL_CRITERIA_WRITE_PEM_CERT,
};

struct ssl_criteria_node_gamma {
    struct ssl_criteria_node **terms;
    int	nterms;
};

struct ssl_criteria_node_unary {
    enum ssl_criteria_unary_type	type;
    struct ssl_criteria_node *arg;
    int	i;			/* yeah, this would make it a binary.  sue me*/
};

struct ssl_criteria_node_primitive {
    enum ssl_criteria_primitive_type	type;
    char	*s;
    int		i;
    X509	*x;
    EVP_MD	*md_type;
};


struct ssl_criteria_node {
    enum ssl_criteria_node_type		type;
    union {
	struct ssl_criteria_node_gamma		gamma;
	struct ssl_criteria_node_unary		unary;
	struct ssl_criteria_node_primitive	primitive;
    } u;
};

/********************************************************************/



/********************************************************************/
/* functions                                                        */
/********************************************************************/

/* returns 0 or 1.  Designed for use with SSL_CTX_set_cert_verify_cb */
int replacement_X509_verify_cert(/*X509_STORE_CTX *ctx*/);

/* looks at argv[0] to find a valid ssl criteria sequence.
   returns how many items from argv it consumed, or 0 on failure (in *d_argc).
   It makes pointers to strings in argv, so don't free argv till you've
   freed the returned tree.
   */
struct ssl_criteria_node * ssl_criteria_argv_rdp_unary
	(/* char **argv, int argc, int *d_argc */);
struct ssl_criteria_node * ssl_criteria_argv_rdp_andlist
	(/* char **argv, int argc, int *d_argc */);
struct ssl_criteria_node * ssl_criteria_argv_rdp_orlist
	(/* char **argv, int argc, int *d_argc */);
struct ssl_criteria_node * ssl_criteria_argv_rdp_term
	(/* char **argv, int argc, int *d_argc */);

/* examines an SSL certificate chain to see if it satisfies expr_tree.
   returns 1 on success, 0 on failure.  curr_cert is typically passed a
   (X509*)0 */
int ssl_criteria_audit_chain(/*X509_STORE_CTX *ctx, struct ssl_criteria_node *expr_tree, X509 *curr_cert*/);

/* Dump the criteria expression tree to the file pointer.  An initial
   indent of 0 is appropriate for most applications. */
void debug_print_criteria_node(/* FILE *fp, struct ssl_criteria_node *rval, int indent */);

#endif /* ssl_criteria_h_ */
