// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventChannelAdmin.*;
import com.ooc.OBEventChannelFactory.*;
import java.io.*;
import java.util.*;

public class FactPushServer
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);
	    
	    //
	    // Parse command line arguments.
	    //
	    String ecName = null;
	    for(int i = 0; i < args.length; i++)
	    {
		if(args[i].charAt(0) == '-')
		{
		    if(args[i].equals("--help") || args[i].equals("-h"))
		    {
			usage();
                        System.exit(0);
		    }
		    else
		    {
			System.err.println("Unknown option `" + args[i] + "'");
			usage();
			System.exit(1);
		    }
		}
		else if(ecName == null)
		    ecName = args[i];
		else
		{
		    usage();
		    System.exit(1);
		}
	    }

	    if (ecName == null)
	    {
		usage();
		System.exit(1);
	    }
	
            //
            // Get event channel factory.
            //
	    org.omg.CORBA.Object objF = null;
	
	    try
	    {
		objF = orb.resolve_initial_references("EventChannelFactory");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println(": can't resolve `EventChannelFactory'");
		System.exit(1);
	    }
	
	    if(objF == null)
	    {
		System.err.println(
		    "`EventChannelFactory' is a nil object reference");
		System.exit(1);
	    }
	
	    EventChannelFactory f = EventChannelFactoryHelper.narrow(objF);
	    if(f == null)
	    {
		System.err.println("`EventChannelFactory' is not an " +
				   "EventChannelFactory object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;

	    try
	    {
		obj = f.get_channel_by_id(ecName);
	    }
	    catch(com.ooc.OBEventChannelFactory.ChannelNotAvailable ex)
	    {
		try
		{
		    obj = f.create_channel(ecName);
		    System.err.println("`Channel " + ecName + "' created");
		}
		catch(com.ooc.OBEventChannelFactory.ChannelAlreadyExists ex2)
		{
		}
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`" + ecName + "' is a nil " +
				   "object reference");
		System.exit(1);
	    }
	    
	    EventChannel e = EventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`" + ecName + "' is not an EventChannel " +
				   "object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get ProxyPushConsumer.
	    //
	    SupplierAdmin supplierAdmin = e.for_suppliers();
	    ProxyPushConsumer consumer = supplierAdmin.obtain_push_consumer();
	    
	    //
	    // Connect implementation to ProxyPushConsumer.
	    //
	    PushSupplier_impl supplier = new PushSupplier_impl(consumer);
	    
	    try
	    {
		consumer.connect_push_supplier(null);
	    }
	    catch(AlreadyConnected ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }
	    
	    if(supplier.run() == 1)
		System.exit(1);
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}
	System.exit(0);
    }

    private static void
    usage()
    {
        System.out.println(
            "Usage: java event.FactPushServer event-channel-name\n" +
	    "\n" +
	    "Options:\n" +
	    "-h, --help             Show this message.\n");
    }
}
