// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosTypedEventChannelAdmin.*;
import org.omg.CosEventChannelAdmin.*;
import com.ooc.OBTypedEventChannelFactory.*;
import java.io.*;
import java.util.*;

public class FactTypedPushClient
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);
	
	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);

	    //
	    // Create BOA.
	    //
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    ((com.ooc.CORBA.ORB)orb).conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelThreaded);
	    ((com.ooc.CORBA.BOA)boa).conc_model(
		com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerClient);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.BOA)boa).filter_options(args);
	    
	    //
	    // Parse command line arguments.
	    //
	    boolean slow = false;
	    long timeout = 5;
	    boolean reg = true;
	    String ecName = null;
	    for(int i = 0; i < args.length; i++)
	    {
		if(args[i].charAt(0) == '-')
		{
		    if(args[i].equals("--help") || args[i].equals("-h"))
		    {
			usage();
                        System.exit(0);
		    }
		    else if(args[i].equals("-s") || args[i].equals("--slow"))
		    {
			slow = true;
		    }
		    else if(args[i].equals("-n") ||
			    args[i].equals("--no-register"))
		    {
			reg = false;
		    }
		    else if(args[i].equals("-t") ||
			    args[i].equals("--timeout"))
		    {
			if(i + 1 >= args.length)
			{
			    System.err.println("Argument expected for " +
					       args[i]);
			    System.exit(1);
			}
			try
			{
			    timeout = Long.parseLong(args[i+1]);
			}
			catch(NumberFormatException ex)
			{
			    System.err.println("Bad format for timeout: " +
					       args[i+1]);
			    System.exit(1);
			}
			++i;
		    }
		    else
		    {
			System.err.println("Unknown option `" + args[i] + "'");
			usage();
			System.exit(1);
		    }
		}
		else if(ecName == null)
		    ecName = args[i];
		else
		{
		    usage();
		    System.exit(1);
		}
	    }

	    if (ecName == null)
	    {
		usage();
		System.exit(1);
	    }
	
            //
            // Get event channel factory.
            //
	    org.omg.CORBA.Object objF = null;
	
	    try
	    {
		objF =
		    orb.resolve_initial_references("TypedEventChannelFactory");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println(
		    ": can't resolve `TypedEventChannelFactory'");
		System.exit(1);
	    }
	
	    if(objF == null)
	    {
		System.err.println(
		    "`TypedEventChannelFactory' is a nil object reference");
		System.exit(1);
	    }
	
	    TypedEventChannelFactory f =
		TypedEventChannelFactoryHelper.narrow(objF);
	    if(f == null)
	    {
		System.err.println("`TypedEventChannelFactory' is not a " +
				   "TypedEventChannelFactory object " +
				   "reference");
		System.exit(1);
	    }
	    
	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;

	    try
	    {
		obj = f.get_channel_by_id(ecName);
	    }
	    catch(com.ooc.OBEventChannelFactory.ChannelNotAvailable ex)
	    {
		try
		{
		    obj = f.create_channel(ecName);
		    System.err.println("`Channel " + ecName + "' created");
		}
		catch(com.ooc.OBEventChannelFactory.ChannelAlreadyExists ex2)
		{
		}
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`" + ecName + "' is a nil " +
				   "object reference");
		System.exit(1);
	    }
	    
	    TypedEventChannel e = TypedEventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`" + ecName + "' is not a " +
				   "TypedEventChannel object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get ProxyPushSupplier
	    //
	    TypedConsumerAdmin consumerAdmin = e.for_consumers();
	    ProxyPushSupplier supplier = null;
	    try
	    {
		supplier = consumerAdmin.obtain_typed_push_supplier(
		    "IDL:event/TimerUpdate:1.0");
	    }
	    catch(NoSuchImplementation ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }
		
	    //
	    // Connect implementation to ProxyPushSupplier
	    //
	    TimerUpdate_impl consumer = new TimerUpdate_impl(slow);
	    
	    //
	    // Connect the consumer to the ORB with the same name each
	    // time.
	    //
	    ((com.ooc.CORBA.ORB)orb).connect(consumer, "DefaultConsumer");

	    ((com.ooc.CORBA.BOA)boa).init_servers();

	    if(reg)
	    {
		try
		{
		    supplier.connect_push_consumer(consumer);
		}
		catch(AlreadyConnected ex)
		{
		    ex.printStackTrace();
		    System.exit(1);
		}
		catch(TypeError ex)
		{
		    ex.printStackTrace();
		    System.exit(1);
		}
	    }
	    
	    //
	    // Run implementation.
	    //
	    if(timeout < 0)
		boa.impl_is_ready(null);
	    else
	    {
		try
		{
		    Thread.sleep(timeout * 1000);
		}
		catch(InterruptedException ex)
		{
		}
	    }

	    //
	    // Disconnect the push supplier here to stop the event
	    // service from pushing further events.
	    //
	    supplier.disconnect_push_supplier();
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}
	System.exit(0);
    }

    private static void
    usage()
    {
        System.out.println(
            "Usage: java event.FactTypedPushClient [options] " +
	    "event-channel-name\n" +
	    "\n" +
	    "Options:\n" +
	    "-h, --help             Show this message.\n" +
	    "-s, --slow             Run in `slow' mode.\n" +
	    "-t sec, --time sec     Run for [sec] seconds, -1 forever.\n" +
	    "-n, --no-register      Don't register with the event service.\n");
    }
}
