// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosTypedEventChannelAdmin.*;
import com.ooc.OBTypedEventChannelFactory.*;
import java.io.*;
import java.util.*;

public class FactTypedPushServer
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);
	    
	    //
	    // Parse command line arguments.
	    //
	    String ecName = null;
	    for(int i = 0; i < args.length; i++)
	    {
		if(args[i].charAt(0) == '-')
		{
		    if(args[i].equals("--help") || args[i].equals("-h"))
		    {
			usage();
                        System.exit(0);
		    }
		    else
		    {
			System.err.println("Unknown option `" + args[i] + "'");
			usage();
			System.exit(1);
		    }
		}
		else if(ecName == null)
		    ecName = args[i];
		else
		{
		    usage();
		    System.exit(1);
		}
	    }

	    if (ecName == null)
	    {
		usage();
		System.exit(1);
	    }
	
            //
            // Get event channel factory.
            //
	    org.omg.CORBA.Object objF = null;
	
	    try
	    {
		objF =
		    orb.resolve_initial_references("TypedEventChannelFactory");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println(
		    ": can't resolve `TypedEventChannelFactory'");
		System.exit(1);
	    }
	
	    if(objF == null)
	    {
		System.err.println(
		    "`TypedEventChannelFactory' is a nil object reference");
		System.exit(1);
	    }
	
	    TypedEventChannelFactory f =
		TypedEventChannelFactoryHelper.narrow(objF);
	    if(f == null)
	    {
		System.err.println(
		    "`TypedEventChannelFactory' is not a " +
		    "TypedEventChannelFactory object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;

	    try
	    {
		obj = f.get_channel_by_id(ecName);
	    }
	    catch(com.ooc.OBEventChannelFactory.ChannelNotAvailable ex)
	    {
		try
		{
		    obj = f.create_channel(ecName);
		    System.err.println("`Channel " + ecName + "' created");
		}
		catch(com.ooc.OBEventChannelFactory.ChannelAlreadyExists ex2)
		{
		}
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`" + ecName + "' is a nil " +
				   "object reference");
		System.exit(1);
	    }
	    
	    TypedEventChannel e = TypedEventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`" + ecName + "' is not a " +
				   "TypedEventChannel object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get TypedProxyPushConsumer.
	    //
	    TypedSupplierAdmin supplierAdmin = e.for_suppliers();
	    TypedProxyPushConsumer consumer = null;

	    try
	    {
		consumer = supplierAdmin.obtain_typed_push_consumer(
		    "IDL:event/TimerUpdate:1.0");
	    }
	    catch(InterfaceNotSupported ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }

	    org.omg.CORBA.Object typedConsumer = consumer.get_typed_consumer();

	    TimerUpdate timer = TimerUpdateHelper.narrow(typedConsumer);
	    if(timer == null)
	    {
		System.out.println("narrow failed!");
		System.exit(1);
	    }

	    while(true)
	    {
		java.util.Date date = new java.util.Date();
		String s = "PushSupplier says: " + date.toString();
		timer.time_update(s);

		try
		{
		    Thread.sleep(1000);
		}
		catch(InterruptedException ex)
		{
		}
	    }
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    private static void
    usage()
    {
        System.out.println(
            "Usage: java event.FactTypedPushServer event-channel-name\n" +
	    "\n" +
	    "Options:\n" +
	    "-h, --help             Show this message.\n");
    }
}
