// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventChannelAdmin.*;
import java.io.*;
import java.util.*;

public class PullClient
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);
	    
	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;
	    
	    try
	    {
		obj = orb.resolve_initial_references("EventService");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println("Can't resolve `EventService'");
		System.exit(1);
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`EventService' is a nil object reference");
		System.exit(1);
	    }
	    
	    EventChannel e = EventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`EventChannel' is not an EventChannel " +
				   "object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get ProxyPullSupplier.
	    //
	    ConsumerAdmin consumerAdmin = e.for_consumers();
	    ProxyPullSupplier supplier = consumerAdmin.obtain_pull_supplier();
	    
	    //
	    // Connect implementation to ProxyPullSupplier.
	    //
	    PullConsumer_impl consumer = new PullConsumer_impl(supplier);
	    
	    try
	    {
		supplier.connect_pull_consumer(null);
	    }
	    catch(AlreadyConnected ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }
	    
	    if(consumer.run() == 1)
		System.exit(1);
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	}
	System.exit(0);
    }
}
