// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventComm.*;

class PullSupplier_impl extends _PullSupplierImplBase
{
    private ORB orb_ = ORB.init();
    private PullConsumer consumer_;
    private boolean slow_;

    PullSupplier_impl(PullConsumer consumer, boolean slow)
    {
	consumer_ = consumer;
	slow_ = slow;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public void
    disconnect_pull_supplier()
    {
	consumer_ = null;
    }

    //
    // Supply date and time
    //
    public Any
    pull()
    {
	java.util.Date date = new java.util.Date();
	String s = "PullSupplier says: " + date.toString();

	Any any = orb_.create_any();
	any.insert_string(s);

	if(slow_)
	{
	    try
	    {
		Thread.sleep(2000);
	    }
	    catch(InterruptedException e)
	    {
	    }
	}

	return any;
    }

    public Any
    try_pull(BooleanHolder hasEvent)
    {
	hasEvent.value = true;

	return pull();
    }
}
