// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventComm.*;

class PushConsumer_impl extends _PushConsumerImplBase
{
    private PushSupplier supplier_;
    private boolean slow_;

    PushConsumer_impl(PushSupplier supplier, boolean slow)
    {
	supplier_ = supplier;
	slow_ = slow;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public void
    disconnect_push_consumer()
    {
	System.out.println("disconnect_push_consumer");
    }

    public void
    push(Any any)
    {
	//
	// Display event data if Any is a string
	//
	try
	{
	    String s = any.extract_string();
	    System.out.println(s);
	}
	catch(MARSHAL ex)
	{
	}
	if(slow_)
	{
	    try
	    {
		Thread.sleep(2000);
	    }
	    catch(InterruptedException e)
	    {
	    }
	}
    }
}
