// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventChannelAdmin.*;
import java.io.*;
import java.util.*;

public class PushServer
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Get event service.
	    //
	    org.omg.CORBA.Object obj = null;

	    try
	    {
		obj = orb.resolve_initial_references("EventService");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName e)
	    {
		System.err.println("Can't resolve `EventService'");
		return;
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`EventService' is a nil object reference");
		System.exit(1);
	    }
	    
	    EventChannel e = EventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`EventChannel' is not an EventChannel " +
				   "object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get ProxyPushConsumer.
	    //
	    SupplierAdmin supplierAdmin = e.for_suppliers();
	    ProxyPushConsumer consumer = supplierAdmin.obtain_push_consumer();
	    
	    //
	    // Connect implementation to ProxyPushConsumer.
	    //
	    PushSupplier_impl supplier = new PushSupplier_impl(consumer);
	    
	    try
	    {
		consumer.connect_push_supplier(null);
	    }
	    catch(AlreadyConnected ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }
	    
	    if(supplier.run() == 1)
		System.exit(1);
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}
	System.exit(0);
    }
}
