// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosEventComm.*;

class PushSupplier_impl extends _PushSupplierImplBase
{
    private org.omg.CORBA.ORB orb_ = org.omg.CORBA.ORB.init();

    private PushConsumer consumer_;

    PushSupplier_impl(PushConsumer consumer)
    {
	consumer_ = consumer;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public void
    disconnect_push_supplier()
    {
	consumer_.disconnect_push_consumer();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Provide date and time
    //
    int
    run()
    {
	//
	// Main loop
	//
	while(true)
	{
	    java.util.Date date = new java.util.Date();
	    String s = "PushSupplier says: " + date.toString();

	    Any any = orb_.create_any();
	    any.insert_string(s);

	    try
	    {
		consumer_.push(any);
	    }
	    catch(org.omg.CosEventComm.Disconnected ex)
	    {
		ex.printStackTrace();
		return 1;
	    }
	    catch(org.omg.CORBA.SystemException ex)
	    {
		ex.printStackTrace();
		return 1;
	    }

	    try
	    {
		Thread.sleep(1000);
	    }
	    catch(InterruptedException ex)
	    {
	    }
	}
    }
}
