// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosTypedEventChannelAdmin.*;
import org.omg.CosEventChannelAdmin.*;
import java.io.*;
import java.util.*;

public class TypedPushClient
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);
	
	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);

	    //
	    // Create BOA.
	    //
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    ((com.ooc.CORBA.ORB)orb).conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelThreaded);
	    ((com.ooc.CORBA.BOA)boa).conc_model(
		com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerClient);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.BOA)boa).filter_options(args);
	    
	    //
	    // Parse command line arguments.
	    //
	    boolean slow = false;
	    long timeout = 5;
	    boolean reg = true;
	    for(int i = 0; i < args.length; i++)
	    {
		if(args[i].equals("--help") || args[i].equals("-h"))
		{
		    usage();
                    System.exit(0);
		}
		else if(args[i].equals("-s") || args[i].equals("--slow"))
		{
		    slow = true;
		}
		else if(args[i].equals("-n") ||args[i].equals("--no-register"))
		{
		    reg = false;
		}
		else if(args[i].equals("-t") ||
			args[i].equals("--timeout"))
		{
		    if(i + 1 >= args.length)
		    {
			System.err.println("Argument expected for " + args[i]);
			System.exit(1);
		    }
		    try
		    {
			timeout = Long.parseLong(args[i+1]);
		    }
		    catch(NumberFormatException ex)
		    {
			System.err.println("Bad format for timeout: " +
					   args[i+1]);
			System.exit(1);
		    }
		    ++i;
		}
		else
		{
		    System.err.println("Unknown option `" + args[i] + "'");
		    usage();
		    System.exit(1);
		}
	    }
	    
	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;
 
	    try
	    {
		obj = orb.resolve_initial_references("TypedEventService");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println("Can't resolve `TypedEventService'");
		System.exit(1);
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`TypedEventService' is a nil object " +
				   "reference");
		System.exit(1);
	    }
	    
	    TypedEventChannel e = TypedEventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`TypedEventChannel' is not an "+
				   "TypedEventChannel object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get ProxyPushSupplier
	    //
	    TypedConsumerAdmin consumerAdmin = e.for_consumers();
	    ProxyPushSupplier supplier = null;
	    try
	    {
		supplier = consumerAdmin.obtain_typed_push_supplier(
		    "IDL:event/TimerUpdate:1.0");
	    }
	    catch(NoSuchImplementation ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }
		
	    //
	    // Connect implementation to ProxyPushSupplier
	    //
	    TimerUpdate_impl consumer = new TimerUpdate_impl(slow);
	    
	    //
	    // Connect the consumer to the ORB with the same name each
	    // time.
	    //
	    ((com.ooc.CORBA.ORB)orb).connect(consumer, "DefaultConsumer");

	    ((com.ooc.CORBA.BOA)boa).init_servers();

	    if(reg)
	    {
		try
		{
		    supplier.connect_push_consumer(consumer);
		}
		catch(AlreadyConnected ex)
		{
		    ex.printStackTrace();
		    System.exit(1);
		}
		catch(TypeError ex)
		{
		    ex.printStackTrace();
		    System.exit(1);
		}
	    }
	    
	    //
	    // Run implementation.
	    //
	    if(timeout < 0)
		boa.impl_is_ready(null);
	    else
	    {
		try
		{
		    Thread.sleep(timeout * 1000);
		}
		catch(InterruptedException ex)
		{
		}
	    }

	    //
	    // Disconnect the push supplier here to stop the event
	    // service from pushing further events.
	    //
	    supplier.disconnect_push_supplier();
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}
	System.exit(0);
    }

    private static void
    usage()
    {
        System.out.println(
            "Usage: java event.PushClient [options]\n\n" +
	    "Options:\n" +
	    "-h, --help             Show this message.\n" +
	    "-s, --slow             Run in `slow' mode.\n" +
	    "-t sec, --time sec     Run for [sec] seconds, -1 forever.\n" +
	    "-n, --no-register      Don't register with the event service.\n");
    }
}
