// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package event;

import org.omg.CORBA.*;
import org.omg.CosTypedEventChannelAdmin.*;
import java.io.*;
import java.util.*;

public class TypedPushServer
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Get event channel.
	    //
	    org.omg.CORBA.Object obj = null;

	    try
	    {
		obj = orb.resolve_initial_references("TypedEventService");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName e)
	    {
		System.err.println("Can't resolve `TypedEventService'");
		System.exit(1);
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`TypedEventService' is a nil object "+
				   "reference");
		System.exit(1);
	    }
	    
	    TypedEventChannel e = TypedEventChannelHelper.narrow(obj);
	    if(e == null)
	    {
		System.err.println("`TypedEventChannel' is not an " +
				   "TypedEventChannel object reference");
		System.exit(1);
	    }
	    
	    //
	    // Get TypedProxyPushConsumer.
	    //
	    TypedSupplierAdmin supplierAdmin = e.for_suppliers();
	    TypedProxyPushConsumer consumer = null;

	    try
	    {
		consumer = supplierAdmin.obtain_typed_push_consumer(
		    "IDL:event/TimerUpdate:1.0");
	    }
	    catch(InterfaceNotSupported ex)
	    {
		ex.printStackTrace();
		System.exit(1);
	    }

	    org.omg.CORBA.Object typedConsumer = consumer.get_typed_consumer();

	    TimerUpdate timer = TimerUpdateHelper.narrow(typedConsumer);
	    if(timer == null)
	    {
		System.out.println("narrow failed!");
		System.exit(1);
	    }

	    while(true)
	    {
		java.util.Date date = new java.util.Date();
		String s = "PushSupplier says: " + date.toString();
		timer.time_update(s);

		try
		{
		    Thread.sleep(1000);
		}
		catch(InterruptedException ex)
		{
		}
	    }
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
