# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

NAME		= OBEvent.jar

!include $(top_srcdir)\..\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl

all:: omg ooc

omg: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) --package org.omg --output-dir generated \
	$(IDLDIR)\CosEventComm.idl \
	$(IDLDIR)\CosEventChannelAdmin.idl \
	$(IDLDIR)\CosTypedEventComm.idl \
	$(IDLDIR)\CosTypedEventChannelAdmin.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(OB_LIB);$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\org\omg\CosEventComm\*.java \
	generated\org\omg\CosEventChannelAdmin\*.java \
	generated\org\omg\CosTypedEventComm\*.java \
	generated\org\omg\CosTypedEventChannelAdmin\*.java

ooc: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) --tie --auto-package --output-dir generated \
	$(IDLDIR)\OBEventChannelFactory.idl \
	$(IDLDIR)\OBTypedEventChannelFactory.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(OB_LIB);$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	com\ooc\OBEventChannelFactory\impl\*.java \
	com\ooc\OBTypedEventChannelFactory\impl\*.java \
	com\ooc\CosEventChannelAdmin\impl\*.java \
	com\ooc\CosTypedEventChannelAdmin\impl\*.java \
	generated\com\ooc\OBEventChannelFactory\*.java \
	generated\com\ooc\OBTypedEventChannelFactory\*.java \
	com\ooc\CosEventServer\*.java

jar:
	cd $(top_srcdir)\lib & \
	del /q $(NAME) & \
	$(JAR) $(JARFLAGS) $(NAME) org com

install:: jar
	copy $(top_srcdir)\lib\$(NAME) $(libdir)

clean::
	-rmdir /s /q $(top_srcdir)\lib
