// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class AnyPullerThread extends PropagatorBaseThread
{
    //
    // The proxy.
    //
    private org.omg.CosEventChannelAdmin.ProxyPullConsumer consumer_;

    //
    // The supplier.
    //
    private org.omg.CosEventComm.PullSupplier supplier_;
    
    //
    // The event channel.
    //
    private EventChannel channel_;
    
    //
    // Interval between successive pulls.
    //
    private long pullInterval_;
    
    //
    // Is there a delay between each pull call?
    //
    private boolean hasDelay_;

    AnyPullerThread(
	org.omg.CosEventComm.PullSupplier supplier,
	org.omg.CosEventChannelAdmin.ProxyPullConsumer consumer,
	long id,
	EventChannel channel,
	long pullInterval,
	long maxRetries,
	long retryTimeout,
	double retryMultiplier)
    {
	super("AnyPullerThread", id, maxRetries, retryTimeout,
	      retryMultiplier);
	
	consumer_ = consumer;
	supplier_ = supplier;
	channel_ = channel;
	pullInterval_ = pullInterval;
	hasDelay_ = pullInterval > 0;
    }

    public void run()
    {
        while(!done_)
        {
            try
            {
                Any any = supplier_.pull();
                resetRetry();
                Event_impl event = new Event_impl(any, id_);
                channel_.receive(event);
                if(hasDelay_)
                    delay(pullInterval_);
            }
            catch(COMM_FAILURE ex)
            {
                if(!retry())
                {
                    done_ = true;
                    try
                    {
                        consumer_.disconnect_pull_consumer();
                    }
                    catch(SystemException e)
                    {
                    }
                }
            }
            catch(Exception ex)
            {
                done_ = true;
                try
                {
                    consumer_.disconnect_pull_consumer();
                }
                catch(SystemException e)
                {
                }
            }
        }
    }
}
