// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class AnyPusherThread extends PusherBaseThread
{
    public PushResult pushEvent(Event_impl event)
    {
        PushResult rc;

        try
        {
            consumer_.push(event.any());
            rc = PushResult.Success;
        }
        catch(COMM_FAILURE e)
        {
            rc = PushResult.Retry;
        }
        catch(Exception e)
        {
            rc = PushResult.Failed;
        }
        return rc;
    }

    AnyPusherThread(org.omg.CosEventComm.PushConsumer consumer,
                    org.omg.CosEventChannelAdmin.ProxyPushSupplier proxy,
                    long id,
                    long maxEvents,
                    long maxRetries,
                    long retryTimeout,
                    double retryMultiplier)
    {
        super("AnyPusherThread", consumer, proxy, id, maxEvents, maxRetries,
	      retryTimeout, retryMultiplier);
    }
}
