// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package com.ooc.CosEventChannelAdmin.impl;

import java.util.*;
import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class ConsumerAdmin extends org.omg.CosEventChannelAdmin._ConsumerAdminImplBase
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // My event channel.
    //
    private EventChannel channel_;

    //
    // Set of proxy suppliers.
    //
    private Vector proxies_ = new Vector();

    //
    // ID of the next assigned proxy.
    //
    private long nextId_ = 0;

    //
    // Has this admin been destroyed?
    //
    private boolean destroyed_ = false;

    ConsumerAdmin(ORB orb, EventChannel e)
    {
        orb_ = orb;
        channel_ = e;
    }
                  
    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    //
    // Get ProxyPushSupplier.
    //
    synchronized public org.omg.CosEventChannelAdmin.ProxyPushSupplier
    obtain_push_supplier()
    {
        if(destroyed_)
            throw new OBJECT_NOT_EXIST();

	ProxyPushSupplier p =
            new ProxyPushSupplier(orb_, this, nextId_++);
        proxies_.addElement(p);

	return p;
    }

    //
    // Get ProxyPullSupplier.
    //
    synchronized public org.omg.CosEventChannelAdmin.ProxyPullSupplier
    obtain_pull_supplier()
    {
        if(destroyed_)
            throw new OBJECT_NOT_EXIST();
        
	ProxyPullSupplier p =
            new ProxyPullSupplier(orb_, this, nextId_++);
	proxies_.addElement(p);

	return p;
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------
    
    //
    // Receive and forward event to all suppliers
    //
    synchronized void
    receive(Event_impl event)
    {
        //
        // Propogate the event to each proxy.
        //
	for(int i = 0 ; i < proxies_.size() ; i++)
	{
            ProxySupplier proxy = (ProxySupplier)proxies_.elementAt(i);
            proxy.receive(event);
	}
    }

    //
    // Remove this proxy from my list
    //
    synchronized void
    removeProxy(ProxySupplier p)
    {
        //
        // Find the element, remove it from the sequence.
        //
	for(int i = 0 ; i < proxies_.size() ; i++)
	    if(proxies_.elementAt(i) == p)
            {
		proxies_.removeElementAt(i);
                return;
            }
        throw new InternalError();
    }

    //
    // Called from the event channel upon destruction.
    //
    synchronized void
    disconnect()
    {
        destroyed_ = true;

        //
        // disconnect each proxy.
        //
        for(int i = 0 ; i < proxies_.size() ; i++)
	{
            ProxySupplier proxy = (ProxySupplier)proxies_.elementAt(i);
            proxy.disconnect();
	}
        proxies_.removeAllElements();

        //
        // Disconnect the servant from the ORB.
        //
        orb_.disconnect(this);
    }
}
