// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import org.omg.CORBA.*;
import com.ooc.CosEventServer.*;

public class EventChannel
    extends org.omg.CosEventChannelAdmin._EventChannelImplBase
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // The consumer admin.
    //
    private ConsumerAdmin consumerAdmin_;

    //
    // The supplier admin.
    //
    private SupplierAdmin supplierAdmin_;

    //
    // The channel's Id.
    //
    private String myId_;

    //
    // Has the channel been destroyed?
    //
    private boolean destroyed_ = false;

    //
    // The event channel factory.
    //
    private com.ooc.OBEventChannelFactory.impl.EventChannelFactory
        eventChannelFactory_;

    public EventChannel(
	ORB orb,
	com.ooc.OBEventChannelFactory.impl.EventChannelFactory
	eventChannelFactory,
	String myId)
    {
	orb_ = orb;
        consumerAdmin_ = new ConsumerAdmin(orb_, this);
        supplierAdmin_ = new SupplierAdmin(orb_, this);
	myId_ = myId;
	eventChannelFactory_ = eventChannelFactory;
	SetDefaultProperties.setDefaults();
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------
    
    public org.omg.CosEventChannelAdmin.ConsumerAdmin
    for_consumers()
    {
	return consumerAdmin_;
    }

    public org.omg.CosEventChannelAdmin.SupplierAdmin
    for_suppliers()
    {
	return supplierAdmin_;
    }

    synchronized public void
    destroy()
    {
	if(destroyed_)
	    throw new org.omg.CORBA.OBJECT_NOT_EXIST();
	destroyed_ = true;

	eventChannelFactory_.removeChannel(myId_);
	
	orb_.disconnect(this);
        
        consumerAdmin_.disconnect();
        supplierAdmin_.disconnect();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------
    
    //
    // Receive event
    //
    void
    receive(com.ooc.CosEventServer.Event_impl event)
    {
	//
	// Forward event to the consumers
	//
        consumerAdmin_.receive(event);
    }
}
