// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class ProxyPullConsumer
    extends org.omg.CosEventChannelAdmin._ProxyPullConsumerImplBase
    implements ProxyConsumer
{
        //
    // The ORB.
    //
    private ORB orb_;

    //
    // My pull supplier.
    //
    private org.omg.CosEventComm.PullSupplier supplier_;

    //
    // My event channel.
    //
    private EventChannel channel_;

    //
    // My admin.
    //
    private SupplierAdmin admin_;

    //
    // My state.
    //
    private ProxyState state_;

    //
    // The event puller.
    //
    private PropagatorBaseThread puller_;

    //
    // My ID.
    //
    private long id_;
    
    ProxyPullConsumer(ORB orb, EventChannel channel, SupplierAdmin admin,
		      long id)
    {
	orb_ = orb;
	channel_ = channel;
	admin_ = admin;
	state_ = ProxyState.Disconnected;
	id_ = id;

	if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
	{
	    com.ooc.CORBA.MessageViewer.instance().
		trace(2, "Create ProxyPullConsumer(" + id_ + ") from " +
		      EventUtil.getConnectionAddrDescription(orb_));
	}
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    synchronized public void
    connect_pull_supplier(org.omg.CosEventComm.PullSupplier supplier)
	throws org.omg.CosEventChannelAdmin.AlreadyConnected
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	if(supplier == null)
	    throw new BAD_PARAM();
	
	if(state_ == ProxyState.Connected)
	    throw new org.omg.CosEventChannelAdmin.AlreadyConnected();
	
	supplier_ = supplier;
	
	state_ = ProxyState.Connected;
	
	if(puller_ != null)
	    throw new InternalError();
	
	//
	// Resolve the QoS params
	//
	try
	{
	    com.ooc.CORBA.Properties properties =
		com.ooc.CORBA.Properties.instance();
	    long pullInterval =
		Long.parseLong(properties.getProperty(EventQoS.PULL_INTERVAL));
	    long retryTimeout =
		Long.parseLong(properties.getProperty(EventQoS.RETRY_TIMEOUT));
	    double retryMultiplier =
		Double.valueOf(properties.getProperty(
		    EventQoS.RETRY_MULTIPLIER)).doubleValue();
	    long maxRetries =
		Long.parseLong(properties.getProperty(EventQoS.MAX_RETRIES));
	    
	    puller_ = new AnyPullerThread(supplier, this, id_, channel_,
					  pullInterval, maxRetries,
					  retryTimeout, retryMultiplier);
	    puller_.start();
	}
	catch(NumberFormatException e)
	{
	    throw new InternalError();
	}
    }

    public void
    disconnect_pull_consumer()
    {
	//
	// We first must check the state. This is to account for the case
	// that disconnect_pull_consumer is called concurrently.
	//
	ProxyState saveState;
	synchronized(this)
        {
	    if(state_ == ProxyState.Destroyed)
		return;
	    saveState = state_;
	    state_ = ProxyState.Destroyed;
	}

	admin_.removeProxy(this);

	//
	// Stop the puller, if running.
	//
	if(puller_ != null)
	    puller_.halt();
    
	if(saveState == ProxyState.Connected)
	{
	    try
	    {
		supplier_.disconnect_pull_supplier();
	    }
	    catch(SystemException e)
	    {
		// A non-existent supplier doesn't matter in this context.
	    }
	}
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
    
    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Called by the event service to disconnect the supplier.
    //
    public void
    disconnect()
    {
	synchronized(this)
        {
	    //
	    // If the proxy has already been destroyed, return.
	    //
	    if(state_ == ProxyState.Destroyed)
		return;
	    
	    state_ = ProxyState.Destroyed;
	}

	//
	// Stop the puller, wait for it to complete, if running.
	//
	if(puller_ != null)
	{
	    puller_.halt();
	    while(puller_.isAlive())
	    {
		try
		{
		    puller_.join();
		}
		catch(InterruptedException e)
		{
		}
	    }
	}
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
}
