// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import java.util.*;
import org.omg.CORBA.*;

//
// The event channel ProxyPullSupplier implementation
//
class ProxyPullSupplier
    extends org.omg.CosEventChannelAdmin._ProxyPullSupplierImplBase
    implements ProxySupplier
{
    //
    // The ORB
    //
    private ORB orb_;

    //
    // My pull consumer
    //
    private org.omg.CosEventComm.PullConsumer consumer_;

    //
    // My admin.
    //
    private ConsumerAdmin admin_;

    //
    // My state.
    //
    private ProxyState state_ = ProxyState.Disconnected;

    //
    // Maximum number of pending events.
    //
    private long maxEvents_;

    //
    // Queue of pending events.
    //
    private Vector events_ = new Vector();

    //
    // My ID.
    //
    private long id_;

    //
    // Get the first event.
    //
    private Event_impl
    getFirstEvent()
    {
	if(events_.size() == 0)
	    throw new InternalError();
	Event_impl event = (Event_impl)events_.elementAt(events_.size() - 1);
	events_.removeElementAt(events_.size() - 1);
	return event;
    }

    ProxyPullSupplier(ORB orb, ConsumerAdmin admin, long id)
    {
	orb_ = orb;
	admin_ = admin;
	id_ = id;

	//
	// Resolve the QoS params
	//
	com.ooc.CORBA.Properties properties =
	    com.ooc.CORBA.Properties.instance();
	try
	{
	    maxEvents_ = Long.parseLong(
		properties.getProperty(EventQoS.MAX_EVENTS));
	}
	catch(NumberFormatException e)
	{
	    throw new InternalError();
	}
	    
	if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
	{
	    com.ooc.CORBA.MessageViewer.instance().
		trace(2, "Create ProxyPullSupplier(" + id_ + ") from " +
		      EventUtil.getConnectionAddrDescription(orb_));
	}
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    synchronized public void
    connect_pull_consumer(org.omg.CosEventComm.PullConsumer consumer)
	throws org.omg.CosEventChannelAdmin.AlreadyConnected
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	if(state_ == ProxyState.Connected)
	    throw new org.omg.CosEventChannelAdmin.AlreadyConnected();

	if(consumer != null)
	    consumer_ = consumer;

	state_ = ProxyState.Connected;
    }

    synchronized public Any
    pull()
	throws org.omg.CosEventComm.Disconnected
    {
	//
	// Block until there is an event, and we're still connected.
	//
	while(events_.size() == 0 && state_ == ProxyState.Connected)
	{
	    while(true)
	    {
		try
		{
		    wait();
		}
		catch(InterruptedException e)
		{
		    continue;
		}
		break;
	    }
	}
	
	//
	// If we're not connected, then raise an exception.
	//
	if(state_ != ProxyState.Connected)
	    throw new org.omg.CosEventComm.Disconnected();
	
	//
	// Get the first event, and return the data.
	//
	Event_impl event = getFirstEvent();
	
	return event.any();
    }

    synchronized public Any
    try_pull(BooleanHolder hasEvent)
	throws org.omg.CosEventComm.Disconnected
    {
	//
	// If we're not connected, then raise an exception.
	//
	if(state_ != ProxyState.Connected)
	    throw new org.omg.CosEventComm.Disconnected();
	
	//
	// Determine if we have an event.
	//
	hasEvent.value = events_.size() != 0;
	Any any;
	if(hasEvent.value)
	{
	    //
	    // Yes, then get the first event. Return the data.
	    //
	    Event_impl event = getFirstEvent();
	    any = event.any();
	}
	else
	{
	    any = orb_.create_any();
	}
	return any;
    }

    public void
    disconnect_pull_supplier()
    {
	//
	// We first must check the state. This is to account for the case
	// that disconnect_pull_supplier is called concurrently. We don't
	// simply lock the entire method because that can cause a deadlock
	// between receive and this method.
	//
	ProxyState saveState;
	synchronized(this)
        {
	    if(state_ == ProxyState.Destroyed)
		return;
	    saveState = state_;
	    state_ = ProxyState.Destroyed;

	    //
	    // Notify on state change.
	    //
	    notify();
	}
	
	admin_.removeProxy(this);

	//
	// If we're connected then tell the consumer.
	//
	if(saveState == ProxyState.Connected && consumer_ != null)
	{
	    try
	    {
		consumer_.disconnect_pull_consumer();
	    }
	    catch(SystemException e)
	    {
	    }
	}
	
	//
	// Disconnect servant from ORB.
	//
	orb_.disconnect(this);
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Receive event and add to queue
    //
    synchronized public void
    receive(Event_impl event)
    {
	//
	// Don't accumulate new events while the channel isn't connected.
	//
	if(state_ != ProxyState.Connected)
	    return;
	
	//
	// If we queue more than maxEvents_ items then we throw oldest
	// items away first.
	//
	events_.insertElementAt(event, 0);
	
	if(events_.size() > maxEvents_)
	{
	    Event_impl e = (Event_impl)events_.elementAt(events_.size() - 1);
	    if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
	    {
		com.ooc.CORBA.MessageViewer.instance().
		    trace(2, "ProxyPullSupplier(" + id_ +
			  ") Discarding event (" + e.eventId() + ")");
	    }
	    events_.removeElementAt(events_.size() - 1);
	}
	
	//
	// Wake any waiting pull() events.
	//
	notify();
    }

    //
    // Called by the event service to disconnect the supplier.
    //
    synchronized public void
    disconnect()
    {
	if(state_ == ProxyState.Destroyed)
	    return;

	//
	// Mark the servant as destroyed, wake any waiting threads.
	//
	state_ = ProxyState.Destroyed;
	notify();
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
}
