// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class ProxyPushConsumer
    extends org.omg.CosEventChannelAdmin._ProxyPushConsumerImplBase
    implements ProxyConsumer
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // My push supplier.
    //
    private org.omg.CosEventComm.PushSupplier supplier_;

    //
    // My event channel.
    //
    private EventChannel channel_;

    //
    // My admin.
    //
    private SupplierAdmin admin_;

    //
    // My state.
    //
    private ProxyState state_ = ProxyState.Disconnected;

    //
    // My ID.
    //
    private long id_;

    ProxyPushConsumer(ORB orb, EventChannel channel, SupplierAdmin admin,
		      long id)
    {
	orb_ = orb;
	channel_ = channel;
	admin_ = admin;
	id_ = id;

	if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
        {
            com.ooc.CORBA.MessageViewer.instance().
                trace(2, "Create ProxyPushConsumer(" + id_ + ") from " +
                      EventUtil.getConnectionAddrDescription(orb_));
        }
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------
    
    synchronized public void
    connect_push_supplier(org.omg.CosEventComm.PushSupplier supplier)
	throws org.omg.CosEventChannelAdmin.AlreadyConnected
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	if(state_ == ProxyState.Connected)
	    throw new org.omg.CosEventChannelAdmin.AlreadyConnected();
	
	//
	// The supplier is permitted to be nil
	//
	if(supplier != null)
	    supplier_ = supplier;

	state_ = ProxyState.Connected;
    }

    public void
    disconnect_push_consumer()
    {
	//
	// We first must check the state. This is to account for the
	// case that disconnect_push_consumer is called concurrently.
	//
	ProxyState saveState;
	synchronized(this)
        {
	    if(state_ == ProxyState.Destroyed)
		return;
	    saveState = state_;
	    state_ = ProxyState.Destroyed;
	}
	
	admin_.removeProxy(this);
	
	//
	// Since we don't necessarily have a supplier, we need to verify
	// before invoking a method.
	//
	if(saveState == ProxyState.Connected && supplier_ != null)
	{
	    try
	    {
		supplier_.disconnect_push_supplier();
	    }
	    catch(SystemException e)
	    {
	    }
	}
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
    
    public void
    push(Any any)
	throws org.omg.CosEventComm.Disconnected
    {
        synchronized(this)
        {
            if(state_ == ProxyState.Destroyed)
                return;
        }
	Event_impl event = new Event_impl(any, id_);
	channel_.receive(event);
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Called by the event service to disconnect the supplier.
    //
    synchronized public void
    disconnect()
    {
	//
	// If the proxy has already been destroyed, return.
	//
	if(state_ == ProxyState.Destroyed)
	    return;
	
	state_ = ProxyState.Destroyed;
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }

    long
    proxyId()
    {
	return id_;
    }
}
