// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class ProxyPushSupplier
    extends org.omg.CosEventChannelAdmin._ProxyPushSupplierImplBase
    implements ProxySupplier
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // My admin.
    //
    private ConsumerAdmin admin_;

    //
    // My state.
    //
    private ProxyState state_ = ProxyState.Disconnected;

    //
    // The event pusher.
    //
    private PusherBaseThread pusher_;
    
    //
    // My consumer.
    //
    private org.omg.CosEventComm.PushConsumer consumer_;

    //
    // My ID.
    //
    private long id_;

    ProxyPushSupplier(ORB orb, ConsumerAdmin admin, long id)
    {
        orb_ = orb;
        admin_ = admin;
        id_ = id;

        if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
        {
            com.ooc.CORBA.MessageViewer.instance().
                trace(2, "Create ProxyPushSupplier(" + id_ + ") from " +
                      EventUtil.getConnectionAddrDescription(orb_));
        }
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------
    
    synchronized public void
    connect_push_consumer(org.omg.CosEventComm.PushConsumer consumer)
	throws org.omg.CosEventChannelAdmin.AlreadyConnected
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	if(consumer == null)
	    throw new BAD_PARAM();

	if(state_ == ProxyState.Connected)
	    throw new org.omg.CosEventChannelAdmin.AlreadyConnected();

	consumer_ = consumer;
	
	state_ = ProxyState.Connected;

	//
	// Resolve the QoS params, create the AnyPusherThread, and start
	// the thread running.
	//
	if(pusher_ != null)
	    throw new InternalError();
	
	com.ooc.CORBA.Properties properties =
	    com.ooc.CORBA.Properties.instance();
	try
	{
	    long maxEvents =
		Long.parseLong(properties.getProperty(EventQoS.MAX_EVENTS));
	    long retryTimeout =
		Long.parseLong(properties.getProperty(EventQoS.RETRY_TIMEOUT));
	    double retryMultiplier =
		Double.valueOf(properties.
			       getProperty(EventQoS.RETRY_MULTIPLIER)).
		doubleValue();
	    long maxRetries =
		Long.parseLong(properties.getProperty(EventQoS.MAX_RETRIES));
	    
	    pusher_ = new AnyPusherThread(consumer, this, id_, maxEvents,
					  maxRetries, retryTimeout,
					  retryMultiplier);
	    pusher_.start();
	}
	catch(NumberFormatException e)
	{
	    throw new InternalError();
	}
    }

    public void
    disconnect_push_supplier()
    {
	ProxyState saveState;
	
	//
	// We first must check the state. This is to account for the case
	// that disconnect_push_supplier is called concurrently. We don't
	// simply lock the entire method because that can cause a deadlock
	// between receive and this method.
        //
	synchronized(this)
	{
	    if(state_ == ProxyState.Destroyed)
		return;
	    saveState = state_;
	    state_ = ProxyState.Destroyed;
	}

	admin_.removeProxy(this);

	//
	// Ask the pusher to stop, if running.
	//
	if(pusher_ != null)
	    pusher_.halt();

	//
	// If we're connected then tell the consumer.
	//
	if(saveState == ProxyState.Connected)
	{
	    try
	    {
		consumer_.disconnect_push_consumer();
	    }                                              
	    catch(SystemException e)
	    {
	    }
	}
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Receive and forward an event
    //
    synchronized public void
    receive(Event_impl event)
    {
	//
	// Don't accumulate events if we're not yet connected.
	//
	if(state_ != ProxyState.Connected)
	    return;

	pusher_.newEvent(event);
    }

    //
    // Called by the event service to disconnect the supplier.
    //
    public void
    disconnect()
    {
	synchronized(this)
        {
	   //
	   // If the proxy has already been destroyed, return.
	   //
	   if(state_ == ProxyState.Destroyed)
	       return;
	   
	   state_ = ProxyState.Destroyed;
        }
	
	//
	// Ask the event pusher to stop, wait for it to complete, if
	// running.
	//
	if(pusher_ != null)
	{
	    pusher_.halt();
	    while(pusher_.isAlive())
	    {
		try
		{
		    pusher_.join();
		}
		catch(InterruptedException e)
		{
		}
	    }
	}
        
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
}
