// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventChannelAdmin.impl;

import java.util.*;
import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class SupplierAdmin
    extends org.omg.CosEventChannelAdmin._SupplierAdminImplBase
{
    
    //
    // The ORB.
    //
    private ORB orb_;
    
    //
    // My event channel.
    //
    private EventChannel channel_;

    //
    // Set of ProxyConsumers.
    //
    private Vector proxies_ = new Vector();

    //
    // ID of the next assigned proxy.
    //
    private long nextId_ = 0;

    //
    // Has this admin been destroyed?
    //
    private boolean destroyed_ = false;

    SupplierAdmin(ORB orb, EventChannel e)
    {
	orb_ = orb;
	channel_ = e;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    //
    // Get ProxyPushConsumer.
    //
    synchronized public org.omg.CosEventChannelAdmin.ProxyPushConsumer
    obtain_push_consumer()
    {
	if(destroyed_)
	    throw new OBJECT_NOT_EXIST();
	
	ProxyPushConsumer p =
	    new ProxyPushConsumer(orb_, channel_, this, nextId_++);
	proxies_.addElement(p);

	return p;
    }

    //
    // Get ProxyPullConsumer.
    //
    synchronized public org.omg.CosEventChannelAdmin.ProxyPullConsumer
    obtain_pull_consumer()
    {
	if(destroyed_)
	    throw new OBJECT_NOT_EXIST();

	ProxyPullConsumer p =
	    new ProxyPullConsumer(orb_, channel_, this, nextId_++);
	proxies_.addElement(p);

	return p;
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Remove this proxy from my list.
    //
    synchronized void
    removeProxy(ProxyConsumer p)
    {
	//
	// Find the element, and remove it from the sequence.
	//
	for(int i = 0 ; i < proxies_.size() ; i++)
	    if(proxies_.elementAt(i) == p)
	    {
		proxies_.removeElementAt(i);
		return;
	    }
	throw new InternalError();
    }

    //
    // Called from the event channel upon destruction.
    //
    synchronized void
    disconnect()
    {
	if(destroyed_)
	    throw new InternalError();
	destroyed_ = true;
	
	//
	// disconnect each proxy.
	//
	for(int i = 0; i < proxies_.size(); ++i)
	{
	    ProxyConsumer p = (ProxyConsumer)proxies_.elementAt(i);
	    p.disconnect();
	}
	proxies_.removeAllElements();
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
}
