// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

import org.omg.CORBA.*;

public class EventUtil
{
    static public String getConnectionAddrDescription(ORB orb)
    {
        org.omg.CORBA.Object obj = null;
        try
        {
	    obj = orb.resolve_initial_references("OCICurrent");
	}
        catch(org.omg.CORBA.ORBPackage.InvalidName e)
	{
	}
	if(obj == null)
	    throw new InternalError();
	com.ooc.OCI.Current current = com.ooc.OCI.CurrentHelper.narrow(obj);
	if(current == null)
	    throw new InternalError();
	com.ooc.OCI.TransportInfo baseInfo = current.get_oci_transport_info();
	com.ooc.OCI.IIOP.TransportInfo info =
	    com.ooc.OCI.IIOP.TransportInfoHelper.narrow(baseInfo);
	String desc;
	if(info != null)
	{
	    int[] remoteAddr = addr(info.remote_addr());
	    int remotePort = port(info.remote_port());
	    desc = new String("");
	    desc += remoteAddr[0];
	    desc += '.';
	    desc += remoteAddr[1];
	    desc += '.';
	    desc += remoteAddr[2];
	    desc += '.';
	    desc += remoteAddr[3];
	    desc += ':';
	    desc += remotePort;
	}
	else
	{
	    desc = "UNKNOWN";
	}
	return desc;
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    static int
    port(short s)
    {
	if(s < 0)
	    return 0xffff + (int)s + 1;
	else
	    return (int)s;
    }
    
    static int[]
    addr(byte[] bArray)
    {
	int[] iArray = new int[4];
	for(int i = 0 ; i < 4 ; i++)
	    if(bArray[i] < 0)
		iArray[i] = 0xff + (int)bArray[i] + 1;
	    else
		iArray[i] = (int)bArray[i];
	
	return iArray;
    }
}
