// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

import org.omg.CORBA.*;

public class Event_impl
{
    //
    // For typed event.
    //
    private NVList args_; // The arguments.
    private String op_; // The operation name.

    //
    // For an untyuped event.
    //
    private Any any_; // The event data.

    private long id_; // My ID.

    private static long nextId_ = 0;

    private void init(long proxyId)
    {
        id_ = nextId_++;
        if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 3)
        {
            com.ooc.CORBA.MessageViewer.instance().
                trace(3, "Create Event(" + id_ + ") from " + proxyId);
        }
    }
    
    public Event_impl(Any any, long proxyId)
    {
        any_ = any;
        init(proxyId);
    }

    public Event_impl(NVList args, String op, long proxyId)
    {
        args_ = args;
        op_ = op;
        init(proxyId);
    }

    //
    // For any events.
    //
    public Any any()
    {
        return any_;
    }

    //
    // For typed events.
    //
    public String op()
    {
        return op_;
    }

    public NVList args()
    {
        return args_;
    }

    public long eventId()
    {
        return id_;
    }
}
