// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

//
// This class provides a base class for those threads that push and
// pull events.
//
public class PropagatorBaseThread extends Thread
{
    private long maxRetries_; // Max retries.
    
    private long retryTimeout_; // Initial timeout (msec).
    
    private double retryMultiplier_; // Retry multiplier (msec).

    private long retry_; // Number of msec for next retry.
    
    private long retries_; // Number of retries.

    public boolean done_; // Are we done?

    public long id_; // The proxy id.

    //
    // Run the retry algorithm.
    //
    synchronized public boolean retry()
    {
	//
	// Have we exceeded the max number of retries?
	//
	if(++retries_ > maxRetries_)
	    return false;
	
	//
	// Provide some debugging information.
	//
	if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
	{
	    com.ooc.CORBA.MessageViewer.instance().
		trace(2, "retry(" + id_ + ") " + retries_ + "/" + maxRetries_ +
		      " in " + retry_ + " ms");
	}
	
	delay(retry_);
	
	//
	// Calculate the next timeout interval.
	//
	retry_ = (long)((double)retry_ * retryMultiplier_);
	
	return !done_;
    }

    //
    // Delay for msecs.
    //
    synchronized public void delay(long msec)
    {
	//
	// When are we done?
	//
	long timeDone = System.currentTimeMillis() + msec;
	while(!done_)
	{
	    //
	    // Are we done yet?
	    //
	    long now = System.currentTimeMillis();
	    if(timeDone <= now)
		break;
	    
	    //
	    // No, calculate how long we have to wait now.
	    //
	    long interval = timeDone - now;
	    
	    //
	    // Block for this long. If we are interrupted before this
	    // interval then we are either done, or we have to
	    // recalculate.
	    //
	    try
	    {
		wait(interval);
	    }
	    catch(InterruptedException e)
	    {
	    }
	}
    }

    //
    // Reset the retry algorithm.
    //
    public void resetRetry()
    {
	retries_ = 0;
	retry_ = retryTimeout_;
    }

    public PropagatorBaseThread(String name, long id, long maxRetries,
				long retryTimeout, double retryMultiplier)
    {
	super("ORBACUS:EventService:" + name + "-" + id);

	maxRetries_ = maxRetries;
	retryTimeout_ = retryTimeout;
	retryMultiplier_ = retryMultiplier;
	retry_ = retryTimeout;
	retries_ = 0;
	done_ = false;
	id_ = id;
    }
    
    //
    // Stop the thread.
    //
    synchronized public void halt()
    {
	done_ = true;
	notify();
    }
}
