// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

import java.util.*;

abstract public class PusherBaseThread extends PropagatorBaseThread
{
    //
    // The event queue.
    //
    private Vector events_ = new Vector();

    //
    // The maximum number of events to queue.
    //
    private long maxEvents_;

    //
    // My push consumer.
    //
    public org.omg.CosEventComm.PushConsumer consumer_;

    //
    // My proxy.
    //
    public org.omg.CosEventChannelAdmin.ProxyPushSupplier proxy_;

    public PusherBaseThread(
	String name,
	org.omg.CosEventComm.PushConsumer consumer,
	org.omg.CosEventChannelAdmin.ProxyPushSupplier proxy,
	long id,
	long maxEvents,
	long maxRetries,
	long retryTimeout,
	double retryMultiplier)
    {
	super(name, id, maxRetries, retryTimeout, retryMultiplier);
	maxEvents_ = maxEvents;
	consumer_ = consumer;
	proxy_ = proxy;
    }
		     
    //
    // Pass a new event to the Pusher.
    //
    synchronized public void newEvent(Event_impl event)
    {
	events_.insertElementAt(event, 0);

	//
	// Too many events in the queue? Drop the last event.
	//
	if(events_.size() > maxEvents_)
	{
	    Event_impl e = (Event_impl)events_.elementAt(events_.size() - 1);
	    if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
	    {
		com.ooc.CORBA.MessageViewer.instance().
		    trace(2, "PusherBaseThread(" + id_ +
			  ") Discarding event (" + e.eventId());
	    }
	    //
	    // The queue is now one event less.
	    //
	    events_.removeElementAt(events_.size() - 1);
	    
	}

	notify();
    }

    //
    // Run the pusher until stopped, or a push fails.
    //
    public void run()
    {
	Event_impl event;
	while((event = waitEvent()) != null)
	{
	    PushResult rc = pushEvent(event);
	    if(rc == PushResult.Success)
	    {
		resetRetry();
		removeEvent(event);
	    }
	    else
	    {
		if(rc == PushResult.Retry)
		{
		    //
		    // If retry returns true, then we should send the event at
		    // the front of the event queue.
		    //
		    if(retry())
			continue;
		    
		    if(com.ooc.CORBA.MessageViewer.instance().
		       getTraceLevel() >= 2)
		    {
			com.ooc.CORBA.MessageViewer.instance().
			    trace(2, "Retries exceeded: disconnect " + id_);
		    }
		    //
		    // fall through
		    //
		}
		    
		// PushResult.Failed:
		try
		{
		    proxy_.disconnect_push_supplier();
		}
		catch(Exception e)
		{
		}
	    }
	}
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Wait until we are terminated or for the next event to
    // arrive. Return the event if available, 0 is not.
    //
    synchronized private Event_impl waitEvent()
    {
	while(!done_ && events_.size() == 0)
	{
	    try
	    {
		wait();
	    }
	    catch(InterruptedException e)
	    {
	    }
	}
	Event_impl event;
	if(!done_)
	{
	    event = (Event_impl)events_.elementAt(events_.size()-1);
	}
	else
	{
	    event = null;
	}
	return event;
    }

    //
    // Remove this event from the event queue.
    //
    private synchronized void removeEvent(Event_impl event)
    {
	//
	// We know that either this event is either the last event, or not
	// in the event list at all.
	//
	if(events_.elementAt(events_.size()-1) == event)
	    events_.removeElementAt(events_.size()-1);
    }

    public abstract PushResult pushEvent(Event_impl event);
}
