// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

import org.omg.CORBA.*;
import org.omg.CosEventChannelAdmin.*;
import java.util.*;

public class Server
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
	    boolean typedService = false;
	    int i;
	    
            //
	    // Set the program name
	    //
	    String progName = "com.ooc.CosEventServer.Server";

            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);
 
	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);

	    //
	    // Prescan the arguments to determine if we're running the
	    // typed event service or the untyped.
	    //
	    for(i = 0; i < args.length; i++)
	    {
		if(args[i].equals("--typed-service") ||
		   args[i].equals("-t"))
		{
		    typedService = true;
		}
		else if(args[i].equals("--untyped-service") ||
			args[i].equals("-u"))
		{
		    typedService = false;
		}
	    }

	    //
	    // Resolve the service object if available as an initial
	    // reference.
	    //
	    String service = (typedService)
		? "TypedEventService"
		: "EventService";
	    org.omg.CORBA.Object serviceObject = null;
	    try
	    {
		serviceObject = orb.resolve_initial_references(service);
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName e)
	    {
	    }

	    //
	    // Set the IIOP port based on the port defined in the IIOP
	    // profile of the service object (if it exists). Then
	    // create the BOA.
	    //
	    com.ooc.CORBA.BOA.set_iiop_port_from_object(serviceObject);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.BOA)boa).filter_options(args);

	    //
	    // We have to run the BOA in either thread-per-client,
	    // thread-pool or thread-per-request concurrency model.
	    //
	    ((com.ooc.CORBA.ORB)orb).conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelBlocking);
	    com.ooc.CORBA.BOA.ConcModel model =
		((com.ooc.CORBA.BOA)boa).conc_model();
	    if(model != com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerClient &&
	       model != com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPool &&
	       model != com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerRequest)
	    {
		((com.ooc.CORBA.BOA)boa).
		    conc_model(com.ooc.CORBA.BOA.ConcModel.
			       ConcModelThreadPerClient);
	    }

	    //
	    // Get options.
	    //
	    boolean ior = false;

	    for(i = 0 ; i < args.length && args[i].startsWith("-") ; i++)
	    {
		if(args[i].equals("--help") ||
		   args[i].equals("-h"))
		{
		    usage(progName);
		    System.exit(0);
		}
		else if(args[i].equals("--version") ||
			args[i].equals("-v"))
		{
                    System.err.println("Event Service " +
                                       com.ooc.CORBA.Version.version);
		    System.exit(0);
		}
		else if(args[i].equals("--ior") ||
			args[i].equals("-i"))
		{
		    ior = true;
		}
		else if(args[i].equals("--typed-service") ||
			args[i].equals("-t") ||
			args[i].equals("--untyped-service") ||
			args[i].equals("-u"))
		{
		    // ignore
		}
		else
		{
		    System.out.println(progName + ": unknown option `" +
				       args[i] + "'\n");
		    usage(progName);
		    System.exit(1);
		}
	    }

	    //
	    // Create event channel.
	    //
	    com.ooc.OBEventChannelFactory.impl.EventChannelFactory
		untypedFactory = null;
	    com.ooc.OBTypedEventChannelFactory.impl.TypedEventChannelFactory
		typedFactory = null;
	    org.omg.CosEventChannelAdmin.EventChannel untypedChannel = null;
	    org.omg.CosTypedEventChannelAdmin.TypedEventChannel typedChannel
		= null;

	    String s;

	    if(!typedService)
	    {
	        untypedFactory = new com.ooc.OBEventChannelFactory.impl.
		    EventChannelFactory(orb, boa);
		((com.ooc.CORBA.ORB)orb).connect(untypedFactory,
						 "DefaultEventChannelFactory");
		try
		{
		    untypedChannel =
			untypedFactory.create_channel("DefaultEventChannel");
		}
		catch(com.ooc.OBEventChannelFactory.ChannelAlreadyExists e)
		{
		    System.err.println(progName +
				       ": `DefaultEventChannel' " +
				       "already exists.");
		    System.exit(1);
		}
		
		s = orb.object_to_string(untypedChannel);
	    }
	    else
	    {
		try
		{
		    org.omg.CORBA.Object ir =
			orb.resolve_initial_references("InterfaceRepository");
		}
		catch(org.omg.CORBA.ORBPackage.InvalidName e)
		{
		    System.err.println(progName +
				       ": no `InterfaceRepository' initial " +
				       "reference.");
		    System.exit(1);
		}

	        typedFactory = new com.ooc.OBTypedEventChannelFactory.impl.
		    TypedEventChannelFactory(orb, boa);
		((com.ooc.CORBA.ORB)orb).connect(
		    typedFactory, "DefaultTypedEventChannelFactory");
		try
		{
		    typedChannel = typedFactory.create_channel(
			"DefaultTypedEventChannel");
		}
		catch(com.ooc.OBEventChannelFactory.ChannelAlreadyExists e)
		{
		    System.err.println(progName +
				       ": `DefaultTypedEventChannel' " +
				       "already exists.");
		    System.exit(1);
		}

		s = orb.object_to_string(typedChannel);
	    }

	    //
	    // Ensure everything is ready to run when the IOR is
	    // displayed.
	    //
	    ((com.ooc.CORBA.BOA)boa).init_servers();
	    
	    //
	    // Print IOR on standard output.
	    //
	    if(ior)
		System.out.println(s);
 
	    //
	    // Run implementation.
	    //
	    boa.impl_is_ready(null);

	    //
	    // Destroy factory.
	    //
	    if(!typedService)
		untypedFactory.destroy();
	    else
		typedFactory.destroy();
        }
        catch(SystemException ex)
        {
	    ex.printStackTrace();
            System.exit(1);
        }

	System.exit(0);
    }

    static void
    usage(String progName)
    {
	System.err.println("Usage:");
	System.err.println(progName + " [options]\n" +
			   "\n" +
			   "Options:\n" +
			   "-h, --help             " +
			   "Show this message.\n" +
			   "-v, --version          " +
			   "Show Event Service version.\n" +
			   "-i, --ior              " +
			   "Print IOR on standard output.\n" +
			   "-t, --typed-service    " +
			   "Run typed event service.\n" +
			   "-u, --untyped-service  " +
			   "Run untyped event service [default].\n");
    }
}
