// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosEventServer;

import org.omg.CORBA.*;
import org.omg.CosEventChannelAdmin.*;
import java.util.*;

public class SetDefaultProperties
{
    private static final class DefaultProperties
    {
	String key;
	String value;
	
	DefaultProperties(String k, String v)
	{
	    key = k;
	    value = v;
	}
    }

    private static final DefaultProperties[] defaults_ =
    {
	new DefaultProperties(EventQoS.MAX_RETRIES, "10"),
	new DefaultProperties(EventQoS.MAX_EVENTS, "10"),
	new DefaultProperties(EventQoS.RETRY_TIMEOUT, "1000"),
	new DefaultProperties(EventQoS.RETRY_MULTIPLIER, "2"),
	new DefaultProperties(EventQoS.PULL_INTERVAL, "0")
    };

    private static void setDefault(String key)
    {
	for(int i = 0; i < defaults_.length; ++i)
	    if(defaults_[i].key.equals(key))
	    {
		com.ooc.CORBA.Properties.instance().
		    setProperty(defaults_[i].key, defaults_[i].value);
		return;
	    }
    }

    //
    // Set default values for the properties.
    //
    public static void setDefaults()
    {
	String progName = "EventServer";

	com.ooc.CORBA.Properties properties =
	    com.ooc.CORBA.Properties.instance();

	com.ooc.CORBA.MessageViewer viewer =
	    com.ooc.CORBA.MessageViewer.instance();

	//
	// If the value is not set then set to the default.
	//
	int i;
	for(i = 0; i < defaults_.length; ++i)
	    if(properties.getProperty(defaults_[i].key) == null)
		properties.setProperty(defaults_[i].key, defaults_[i].value);
	    
	//
	// Check properties value.
	//
	String[] keys = properties.getKeys("ooc.event.");
	for(i = 0; i < keys.length; ++i)
	{
	    String key = keys[i];
	    String value = properties.getProperty(key);
	    if(value == null)
		throw new InternalError();
		
	    if(key.equals(EventQoS.MAX_RETRIES) ||
	       key.equals(EventQoS.PULL_INTERVAL))
	    {
		long v;
		try
		{
		    v = Long.parseLong(value);
		}
		catch(NumberFormatException e)
		{
		    v = -1;
		}
		if(v < 0)
		{
		    viewer.warning(progName + ": " + key +
				   " must be >= 0. Using default value.");
		    setDefault(key);
		}
	    }
	    else if(key.equals(EventQoS.MAX_EVENTS))
	    {
		long v;
		try
		{
		    v = Long.parseLong(value);
		}
		catch(NumberFormatException e)
		{
		    v = -1;
		}
		if(v <= 0)
		{
		    viewer.warning(progName + ": " + key +
				   " must be > 0. Using default value");
		    setDefault(key);
		}
	    }
	    else if(key.equals(EventQoS.RETRY_TIMEOUT) ||
		    key.equals(EventQoS.RETRY_MULTIPLIER))
	    {
		long v;
		try
		{
		    v = Long.parseLong(value);
		}
		catch(NumberFormatException e)
		{
		    v = -1;
		}
		if(v < 0 || v > 999999)
		{
		    viewer.warning(progName + ": " + key +
				   " must be > 0 and < 999999. " +
				   "Using default value");
		    setDefault(key);
		}
	    }
	    else
	    {
		viewer.warning(progName + ": `" + key +
			       "': unknown property");
	    }
	}
    }
}
