// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package com.ooc.CosTypedEventChannelAdmin.impl;

import java.util.*;
import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class TypedConsumerAdmin
    extends org.omg.CosTypedEventChannelAdmin._TypedConsumerAdminImplBase
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // My event channel.
    //
    private TypedEventChannel channel_;

    //
    // Set of proxy suppliers.
    //
    private Vector proxies_ = new Vector();

    //
    // ID of the next assigned proxy.
    //
    private long nextId_ = 0;

    //
    // Has this admin been destroyed?
    //
    private boolean destroyed_ = false;

    TypedConsumerAdmin(ORB orb, TypedEventChannel e)
    {
        orb_ = orb;
        channel_ = e;
    }
                  
    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    //
    // Get ProxyPushSupplier.
    //
    public org.omg.CosEventChannelAdmin.ProxyPushSupplier
    obtain_push_supplier()
    {
	throw new NO_IMPLEMENT();
    }

    //
    // Get ProxyPullSupplier.
    //
    public org.omg.CosEventChannelAdmin.ProxyPullSupplier
    obtain_pull_supplier()
    {
	throw new NO_IMPLEMENT();
    }

    //
    // Get TypedProxyPushSupplier.
    //
    synchronized
    public org.omg.CosEventChannelAdmin.ProxyPushSupplier
    obtain_typed_push_supplier(String typeId)
	throws org.omg.CosTypedEventChannelAdmin.NoSuchImplementation
    {
	if(destroyed_)
	    throw new OBJECT_NOT_EXIST();
	
	//
	// Attempt to assign this type id to the channel.
	//
	if(!channel_.assignTypeId(typeId))
	    throw new org.omg.CosTypedEventChannelAdmin.
		NoSuchImplementation();
	
	ProxyPushSupplier p =
	    new ProxyPushSupplier(orb_, this, nextId_++);
	proxies_.addElement(p);
	
	return p;
    }
    
    //
    // Get TypedProxyPullSupplier.
    //
    synchronized
    public org.omg.CosTypedEventChannelAdmin.TypedProxyPullSupplier
    obtain_typed_pull_supplier(String typeId)
	throws org.omg.CosTypedEventChannelAdmin.InterfaceNotSupported
    {
	throw new NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------
    
    //
    // Receive and forward event to all suppliers
    //
    synchronized void
    receive(Event_impl event)
    {
        //
        // Propogate the event to each proxy.
        //
	for(int i = 0 ; i < proxies_.size() ; i++)
	{
            ProxySupplier proxy = (ProxySupplier)proxies_.elementAt(i);
            proxy.receive(event);
	}
    }

    //
    // Remove this proxy from my list
    //
    synchronized void
    removeProxy(ProxySupplier p)
    {
        //
        // Find the element, remove it from the sequence.
        //
	for(int i = 0 ; i < proxies_.size() ; i++)
	    if(proxies_.elementAt(i) == p)
            {
		proxies_.removeElementAt(i);
                return;
            }
        throw new InternalError();
    }

    //
    // Called from the event channel upon destruction.
    //
    synchronized void
    disconnect()
    {
        destroyed_ = true;

        //
        // disconnect each proxy.
        //
        for(int i = 0 ; i < proxies_.size() ; i++)
	{
            ProxySupplier proxy = (ProxySupplier)proxies_.elementAt(i);
            proxy.disconnect();
	}
        proxies_.removeAllElements();

        //
        // Disconnect the servant from the ORB.
        //
        orb_.disconnect(this);
    }
}
