// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosTypedEventChannelAdmin.impl;

import java.util.*;
import org.omg.CORBA.*;
import com.ooc.CosEventServer.*;

public class TypedEventChannel
    extends org.omg.CosTypedEventChannelAdmin._TypedEventChannelImplBase
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // The consumer admin.
    //
    private TypedConsumerAdmin consumerAdmin_;

    //
    // The supplier admin.
    //
    private TypedSupplierAdmin supplierAdmin_;

    //
    // Repository IDs for the channel.
    //
    private Vector typeIds_ = new Vector();

    //
    // The channel's Id.
    //
    private String myId_;

    //
    // Has the channel been destroyed?
    //
    private boolean destroyed_ = false;

    //
    // The event channel factory.
    //
    private com.ooc.OBTypedEventChannelFactory.impl.TypedEventChannelFactory
    eventChannelFactory_;

    //
    // The interface def for the repository.
    //
    org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription iface_;

    public TypedEventChannel(
	ORB orb,
	com.ooc.OBTypedEventChannelFactory.impl.TypedEventChannelFactory
	eventChannelFactory,
	String myId)
    {
	orb_ = orb;
        consumerAdmin_ = new TypedConsumerAdmin(orb_, this);
        supplierAdmin_ = new TypedSupplierAdmin(orb_, this);
	myId_ = myId;
	eventChannelFactory_ = eventChannelFactory;
	SetDefaultProperties.setDefaults();
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------
    
    public org.omg.CosTypedEventChannelAdmin.TypedConsumerAdmin
    for_consumers()
    {
	return consumerAdmin_;
    }

    public org.omg.CosTypedEventChannelAdmin.TypedSupplierAdmin
    for_suppliers()
    {
	return supplierAdmin_;
    }

    synchronized public void
    destroy()
    {
	if(destroyed_)
	    throw new org.omg.CORBA.OBJECT_NOT_EXIST();
	destroyed_ = true;

	eventChannelFactory_.removeChannel(myId_);
	
	orb_.disconnect(this);
        
        consumerAdmin_.disconnect();
        supplierAdmin_.disconnect();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------
    
    //
    // Receive event
    //
    void
    receive(com.ooc.CosEventServer.Event_impl event)
    {
	//
	// Forward event to the consumers
	//
        consumerAdmin_.receive(event);
    }

    boolean
    isCompatible(String id)
    {
	for(int i = 0; i < typeIds_.size(); ++i)
	    if(((String)typeIds_.elementAt(i)).equals(id))
		return true;
	return false;
    }

    boolean
    assignTypeId(String id)
    {
	//
	// Do we already have a type-id assigned?
	//
	if(typeIds_.size() != 0)
	    return isCompatible(id);
	
	Repository ir = null;
	try
	{
	    org.omg.CORBA.Object irObj =
		orb_.resolve_initial_references("InterfaceRepository");
	    ir = RepositoryHelper.narrow(irObj);
	}
	catch(org.omg.CORBA.ORBPackage.InvalidName e)
	{
	    //
	    // This is really an internal error since we ensure that there
	    // is a InterfaceRepository at process startup.
	    //
	}
	//
	// We want COMM_FAILURE and TRANSIENT exceptions to cause
	// INTF_REPOS exceptions to be raised. Another valid choice would
	// be InterfaceNotSupported. However, I have chosen to raise
	// INTF_REPOS in the case that the IR isn't available so that the
	// user can differentiate this case from the ID not present in the
	// IR.
	//
	catch(org.omg.CORBA.COMM_FAILURE e)
	{
	}
	catch(org.omg.CORBA.TRANSIENT e)
	{
	}
	if(ir == null)
	    throw new INTF_REPOS();
    
	Contained contained = ir.lookup_id(id);
    
	//
	// Not in the interface repository? Not supported.
	//
	if(contained == null)
	    return false;
	
	InterfaceDef iDef =
	    InterfaceDefHelper.narrow(contained);
	if(iDef == null)
	    return false;

	//
	// Retrieve the type-ids.
	//
	typeIds(iDef);
	
	iface_ = iDef.describe_interface();

	return true;
    }

    org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription
    getIface()
    {
	return iface_;
    }

    private void
    typeIds(InterfaceDef iface)
    {
	typeIds_.addElement(iface.id());
	
	InterfaceDef[] base = iface.base_interfaces();
	for(int i = 0; i < base.length; ++i)
	{
	    //
	    // Get the ID.
	    //
	    String id = base[i].id();
	    
	    //
	    // Find out whether this ID is already in the set of IDs.
	    //
	    int j;
	    for(j = 0; j < typeIds_.size(); ++j)
		if(((String)typeIds_.elementAt(j)).equals(id))
		    break;
	    
	    //
	    // Nope, then add all the typeIds for this interface.
	    //
	    if(j == typeIds_.size())
		typeIds(base[i]);
	}
    }

    String[]
    ids()
    {
	String[] rc = new String[typeIds_.size()];
	for(int i = 0; i < typeIds_.size(); ++i)
	    rc[i] = (String)typeIds_.elementAt(i);
	return rc;
    }
}
