// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosTypedEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

public class TypedProxyPushConsumer
    extends org.omg.CosTypedEventChannelAdmin._TypedProxyPushConsumerImplBase
    implements ProxyConsumer
{
    //
    // The ORB.
    //
    private ORB orb_;

    //
    // My push supplier.
    //
    private org.omg.CosEventComm.PushSupplier supplier_;

    //
    // My event channel.
    //
    private TypedEventChannel channel_;

    //
    // My admin.
    //
    private TypedSupplierAdmin admin_;

    //
    // My state.
    //
    private ProxyState state_ = ProxyState.Disconnected;

    //
    // My ID.
    //
    private long id_;

    private TypedProxyPushConsumerDSI dsiImpl_;

    TypedProxyPushConsumer(
	ORB orb,
	TypedEventChannel channel,
	TypedSupplierAdmin admin,
	org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription iface,
	long id)
    {
	orb_ = orb;
	channel_ = channel;
	admin_ = admin;
	id_ = id;
	dsiImpl_ = new TypedProxyPushConsumerDSI(channel_, orb_, iface, id_);

	if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
        {
            com.ooc.CORBA.MessageViewer.instance().
                trace(2, "Create TypedProxyPushConsumer(" + id_ + ") from " +
                      EventUtil.getConnectionAddrDescription(orb_));
        }
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------
    
    synchronized public org.omg.CORBA.Object
    get_typed_consumer()
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	return dsiImpl_;
    }

    synchronized public void
    connect_push_supplier(org.omg.CosEventComm.PushSupplier supplier)
	throws org.omg.CosEventChannelAdmin.AlreadyConnected
    {
	if(state_ == ProxyState.Destroyed)
	    throw new OBJECT_NOT_EXIST();

	if(state_ == ProxyState.Connected)
	    throw new org.omg.CosEventChannelAdmin.AlreadyConnected();
	
	//
	// The supplier is permitted to be nil
	//
	if(supplier != null)
	    supplier_ = supplier;

	state_ = ProxyState.Connected;
    }

    public void
    disconnect_push_consumer()
    {
	//
	// We first must check the state. This is to account for the case
	// that disconnect_push_consumer is called concurrently.
	//
	ProxyState saveState;
	synchronized(this)
        {
	    if(state_ == ProxyState.Destroyed)
		return;
	    saveState = state_;
	    state_ = ProxyState.Destroyed;
	}
	
	admin_.removeProxy(this);
	
	//
	// Since we don't necessarily have a supplier, we need to verify
	// before invoking a method.
	//
	if(saveState == ProxyState.Connected && supplier_ != null)
	{
	    try
	    {
		supplier_.disconnect_push_supplier();
	    }
	    catch(SystemException e)
	    {
	    }
	}

	//
	// Disconnect the DSI implementation.
	//
	dsiImpl_.disconnect();
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
    
    public void
    push(Any any)
	throws org.omg.CosEventComm.Disconnected
    {
	throw new NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Called by the event service to disconnect the supplier.
    //
    synchronized public void
    disconnect()
    {
	//
	// If the proxy has already been destroyed, return.
	//
	if(state_ == ProxyState.Destroyed)
	    return;
	
	state_ = ProxyState.Destroyed;
	
	//
	// Ask the DSI implementation to go away.
	//
	dsiImpl_.disconnect();

	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }

    long
    proxyId()
    {
	return id_;
    }
}
