// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosTypedEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class TypedProxyPushConsumerDSI extends DynamicImplementation
{
    //
    // The ORB.
    //
    private ORB orb_;
    
    //
    // My event channel.
    //
    private TypedEventChannel channel_;

    //
    // The interface description for the typeId_.
    //
    private org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription iface_;
   
    //
    // Is this destroyed?
    //
    private boolean destroyed_ = false;
    
    //
    // The ID of the associated proxy.
    //
    private long id_;

    TypedProxyPushConsumerDSI(
	TypedEventChannel channel,
	ORB orb,
	org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription iface,
	long id)
    {
	orb_ = orb;
	channel_ = channel;
	iface_ = iface;
	id_ = id;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public String[]
    _ids()
    {
	return channel_.ids();
    }

    public void
    invoke(ServerRequest req)
    {
	//
	// If the proxy is dead, then don't accept any more method
	// invocations.
	//
	if(destroyed_)
	{
	    Any any = orb_.create_any();
	    OBJECT_NOT_EXISTHelper.
		insert(any, new OBJECT_NOT_EXIST());
	    req.except(any);
	    return;
	}
	
	//
	// Rip out the operation name.
	//
	String opName = req.op_name();
	
	//
	// Look up the operation in the IR.
	//
	for(int i = 0; i < iface_.operations.length; i++)
	{
	    if(opName.equals(iface_.operations[i].name))
	    {
		//
		// Have the appropriate operation.
		//
		OperationDescription opDesc =
		    iface_.operations[i];
		
		//
		// Validate the parameters. All in parameters, and no
		// return value, no exceptions.
		//
		if(opDesc.result.kind() != TCKind.tk_void)
		{
		    Any any = orb_.create_any();
		    BAD_OPERATIONHelper.insert(any, new BAD_OPERATION());
		    req.except(any);
		    return;
		}
		
		int j;
		for(j = 0 ; j < opDesc.parameters.length; j++)
		    if(opDesc.parameters[j].mode !=
		       ParameterMode.PARAM_IN)
		    {
			Any any = orb_.create_any();
			BAD_OPERATIONHelper.insert(any, new BAD_OPERATION());
			req.except(any);
			return;
		    }
    
		if(opDesc.exceptions.length > 0)
		{
		    Any any = orb_.create_any();
		    BAD_OPERATIONHelper.insert(any, new BAD_OPERATION());
		    req.except(any);
		    return;
		}

		//
		// Create an NVList to contain the parameters for this
		// method. Firstly create the NVList.
		//
		NVList params = orb_.create_list(0);
		
		//
		// Now process each parameter.
		//
		for(j = 0 ; j < opDesc.parameters.length; j++)
		{
		    ParameterDescription par =
			opDesc.parameters[j];
		    
		    //
		    // Get the name.
		    //
		    String name = par.name;
		    
		    //
		    // Create an any with the appropriate typecode.
		    //
		    Any any = orb_.create_any();
		    any.type(par.type);
		    
		    //
		    // Add this parameter.
		    //
		    params.add_value(name, any, ARG_IN.value);
		}
		
		if(com.ooc.CORBA.MessageViewer.instance().getTraceLevel() >= 2)
		{
		    com.ooc.CORBA.MessageViewer viewer =
			com.ooc.CORBA.MessageViewer.instance();
		    viewer.trace(2, "invoke: " + opName);
		    viewer.trace(2, "params #: " + params.count());

		    try
		    {
			for(int param = 0; param < params.count(); ++param)
			{
			    NamedValue nv = params.item(param);
			    viewer.trace(2, "name: " + nv.name());
			}
		    }
		    catch(Bounds ex)
		    {
			throw new InternalError();
		    }
		}

		req.params(params);
		
		//
		// Create a new Event_impl, and forward this to the event
		// channel.
		//
		Event_impl event = new Event_impl(params, opName, id_);
		channel_.receive(event);
		return;
	    }
	}
	
	//
	// No such operation.
	//
	Any any = orb_.create_any();
	BAD_OPERATIONHelper.insert(any, new BAD_OPERATION());
	req.except(any);
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    void
    disconnect()
    {
	destroyed_ = true;
	orb_.disconnect(this);
    }
}
