// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosTypedEventChannelAdmin.impl;

import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class TypedPusherThread extends PusherBaseThread
{
    public PushResult pushEvent(Event_impl event)
    {
        //
        // Create a DII request.
        //
        Request request = consumer_._request(event.op());

        try
	{
	    //
	    // Insert each of the arguments.
	    //
	    for(int i = 0; i < event.args().count(); ++i)
	    {
		NamedValue nv = event.args().item(i);
		Any arg = request.add_named_in_arg(nv.name());
		org.omg.CORBA.portable.OutputStream out =
		    arg.create_output_stream();
		arg.read_value(nv.value().create_input_stream(),
			       nv.value().type());
	    }
	}
	catch(Bounds e)
	{
	    throw new InternalError();
	}

        PushResult rc;

        try
        {
            //
            // Invoke the request.
            //
            request.invoke();

            //
            // Did we receive an exception?
            //
            Exception e = request.env().exception();
            if(e != null)
                throw e;

            rc = PushResult.Success;
        }
        catch(COMM_FAILURE ex)
        {
            //
            // If the exception is COMM_FAILURE then we retry, failure
            // otherwise.
            //
            rc = PushResult.Retry;
        }
        catch(Exception ex)
        {
            rc = PushResult.Failed;
        }

        return rc;
    }

    TypedPusherThread(org.omg.CosEventComm.PushConsumer consumer,
		      org.omg.CosEventChannelAdmin.ProxyPushSupplier proxy,
		      long id,
		      long maxEvents,
		      long maxRetries,
		      long retryTimeout,
		      double retryMultiplier)
    {
        super("TypedPusherThread", consumer, proxy, id, maxEvents,
	      maxRetries, retryTimeout, retryMultiplier);
    }
}
