// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosTypedEventChannelAdmin.impl;

import java.util.*;
import com.ooc.CosEventServer.*;
import org.omg.CORBA.*;

class TypedSupplierAdmin
    extends org.omg.CosTypedEventChannelAdmin._TypedSupplierAdminImplBase
{
    
    //
    // The ORB.
    //
    private ORB orb_;
    
    //
    // My event channel.
    //
    private TypedEventChannel channel_;

    //
    // Set of ProxyConsumers.
    //
    private Vector proxies_ = new Vector();

    //
    // ID of the next assigned proxy.
    //
    private long nextId_ = 0;

    //
    // Has this admin been destroyed?
    //
    private boolean destroyed_ = false;

    TypedSupplierAdmin(ORB orb, TypedEventChannel e)
    {
	orb_ = orb;
	channel_ = e;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    //
    // Get ProxyPushConsumer.
    //
    public org.omg.CosEventChannelAdmin.ProxyPushConsumer
    obtain_push_consumer()
    {
	throw new NO_IMPLEMENT();
    }

    //
    // Get ProxyPullConsumer.
    //
    public org.omg.CosEventChannelAdmin.ProxyPullConsumer
    obtain_pull_consumer()
    {
	throw new NO_IMPLEMENT();
    }

    //
    // Get TypedProxyPushConsumer.
    //
    synchronized
    public org.omg.CosTypedEventChannelAdmin.TypedProxyPushConsumer
    obtain_typed_push_consumer(String typeId)
	throws org.omg.CosTypedEventChannelAdmin.InterfaceNotSupported
    {
	if(destroyed_)
	    throw new OBJECT_NOT_EXIST();

	//
	// Attempt to assign this type id to the channel.
	//
	if(!channel_.assignTypeId(typeId))
	    throw new org.omg.CosTypedEventChannelAdmin.
		InterfaceNotSupported();
	
	TypedProxyPushConsumer p =
	    new TypedProxyPushConsumer(orb_, channel_, this,
				       channel_.getIface(),
				       nextId_++);
	proxies_.addElement(p);

	return p;
    }

    //
    // Get TypedProxyPullConsumer.
    //
    synchronized
    public org.omg.CosEventChannelAdmin.ProxyPullConsumer
    obtain_typed_pull_consumer(String typeId)
	throws org.omg.CosTypedEventChannelAdmin.NoSuchImplementation
    {
	throw new NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // Internal functions
    // ------------------------------------------------------------------

    //
    // Remove this proxy from my list.
    //
    synchronized void
    removeProxy(ProxyConsumer p)
    {
	//
	// Find the element, and remove it from the sequence.
	//
	for(int i = 0 ; i < proxies_.size() ; i++)
	    if(proxies_.elementAt(i) == p)
	    {
		proxies_.removeElementAt(i);
		return;
	    }
	throw new InternalError();
    }

    //
    // Called from the event channel upon destruction.
    //
    synchronized void
    disconnect()
    {
	if(destroyed_)
	    throw new InternalError();
	destroyed_ = true;
	
	//
	// disconnect each proxy.
	//
	for(int i = 0; i < proxies_.size(); ++i)
	{
	    ProxyConsumer p = (ProxyConsumer)proxies_.elementAt(i);
	    p.disconnect();
	}
	proxies_.removeAllElements();
	
	//
	// Disconnect the servant from the ORB.
	//
	orb_.disconnect(this);
    }
}
