// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OBEventChannelFactory.impl;

import org.omg.CORBA.*;

//
// The event channel factory implementation.
//
public class EventChannelFactory
    extends com.ooc.OBEventChannelFactory._EventChannelFactoryImplBase
{
    private ORB orb_; // The ORB.
    private BOA boa_; // The BOA.

    //
    // Mapping from String to com.ooc.OBEventChannelAdmin.impl.EventChannel
    //
    private java.util.Hashtable channels_;

    // ------------------------------------------------------------------
    // EventChannelFactory_tie Constructor.
    // ------------------------------------------------------------------
    
    public EventChannelFactory(ORB orb, BOA boa)
    {
	orb_ = orb;
	boa_ = boa;

	channels_ = new java.util.Hashtable(63);
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping.
    // ------------------------------------------------------------------

    //
    // Create EventChannel object.
    //
    public org.omg.CosEventChannelAdmin.EventChannel
    create_channel(String id)
	throws com.ooc.OBEventChannelFactory.ChannelAlreadyExists
    {
	com.ooc.CosEventChannelAdmin.impl.EventChannel c =
	    new com.ooc.CosEventChannelAdmin.impl.EventChannel(orb_, this, id);
	try
	{
	    ((com.ooc.CORBA.ORB)orb_).connect(c, id);
	}
	catch(org.omg.CORBA.INV_IDENT e)
	{
	    throw new com.ooc.OBEventChannelFactory.ChannelAlreadyExists();
	}
    
        //
        // Add to channel map
        //
	java.lang.Object old = channels_.put(id, c);
	if(old != null)
	    throw new InternalError();
	
	return c;
    }

    //
    // Get EventChannel object by id.
    //
    public org.omg.CosEventChannelAdmin.EventChannel
    get_channel_by_id(String id)
	throws com.ooc.OBEventChannelFactory.ChannelNotAvailable
    {
        //
        // Retrieve channel.
        //
	com.ooc.CosEventChannelAdmin.impl.EventChannel c =
	(com.ooc.CosEventChannelAdmin.impl.EventChannel)channels_.get(id);

	if(c == null)
	    throw new com.ooc.OBEventChannelFactory.ChannelNotAvailable();

	return c;
    }

    //
    // Get EventChannel object ids.
    //
    public String[]
    get_channels()
    {
	java.util.Vector v = new java.util.Vector();

  	java.util.Enumeration keys = channels_.keys();
  	while(keys.hasMoreElements())
	    v.addElement((String)keys.nextElement());

  	String[] channelIds = new String[v.size()];
	v.copyInto(channelIds);

	return channelIds;
    }
    
    //
    // Shutdown the event service.
    //
    synchronized public void
    shutdown()
    {
	if(boa_ != null)
	{
	    ((com.ooc.CORBA.BOA)boa_).deactivate_impl(null);
	    boa_ = null;
	}
    }

    // ------------------------------------------------------------------
    // Internal methods.
    // ------------------------------------------------------------------
    
    //
    // Destroy.
    //
    public void
    destroy()
    {
        //
	// Prevent callbacks to removeChannel() from the event channels'
	// destroy() method.
	//
	java.util.Hashtable channels = channels_;
	channels_ = null;
    
	//
	// Destroy the event channels.
	//
	java.util.Enumeration elements = channels.elements();
	
	while(elements.hasMoreElements())
	{
	    com.ooc.CosEventChannelAdmin.impl.EventChannel c = 
		(com.ooc.CosEventChannelAdmin.impl.EventChannel)
		elements.nextElement();
	    if(c != null)
		c.destroy();
	}
    }
    
    //
    // Remove Channel.
    //
    public void
    removeChannel(String id)
    {
	if(channels_ != null)
	{
	    //
            // Remove channel.
            //
	    com.ooc.CosEventChannelAdmin.impl.EventChannel c =
		(com.ooc.CosEventChannelAdmin.impl.EventChannel)
		channels_.remove(id);

	    //
	    // If the channel isn't present then this is an internal
	    // error.
	    //
	    if(c == null)
		throw new InternalError();
	}
    }
};
