// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package com.ooc.OBTypedEventChannelFactory.impl;

import org.omg.CORBA.*;

//
// The typed event channel factory implementation.
//
public class TypedEventChannelFactory
    extends
        com.ooc.OBTypedEventChannelFactory._TypedEventChannelFactoryImplBase
{
    private ORB orb_; // The ORB.
    private BOA boa_; // The BOA.

    //
    // Mapping from String to
    // com.ooc.OBTypedEventChannelAdmin.impl.TypedEventChannel
    //
    private java.util.Hashtable channels_;

    // ------------------------------------------------------------------
    // TypedEventChannelFactory_tie constructor.
    // ------------------------------------------------------------------
    
    public TypedEventChannelFactory(ORB orb, BOA boa)
    {
	orb_ = orb;
	boa_ = boa;

	channels_ = new java.util.Hashtable(63);
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping.
    // ------------------------------------------------------------------
    
    //
    // Create TypedEventChannel object.
    //
    public org.omg.CosTypedEventChannelAdmin.TypedEventChannel
    create_channel(String id)
	throws com.ooc.OBEventChannelFactory.ChannelAlreadyExists
    {
	com.ooc.CosTypedEventChannelAdmin.impl.TypedEventChannel c =
	    new com.ooc.CosTypedEventChannelAdmin.impl.
	    TypedEventChannel(orb_, this, id);
	try
	{
	    ((com.ooc.CORBA.ORB)orb_).connect(c, id);
	}
	catch(org.omg.CORBA.INV_IDENT e)
	{
	    throw new com.ooc.OBEventChannelFactory.ChannelAlreadyExists();
	}
    
        //
        // Add to channel map.
        //
	java.lang.Object old = channels_.put(id, c);
	if(old != null)
	    throw new InternalError();
	
	return c;
    }

    //
    // Get TypedEventChannel object by id.
    //
    public org.omg.CosTypedEventChannelAdmin.TypedEventChannel
    get_channel_by_id(String id)
	throws com.ooc.OBEventChannelFactory.ChannelNotAvailable
    {
        //
        // Retrieve channel.
        //
	com.ooc.CosTypedEventChannelAdmin.impl.TypedEventChannel c =
	    (com.ooc.CosTypedEventChannelAdmin.impl.TypedEventChannel)
	    channels_.get(id);

	if(c == null)
	    throw new com.ooc.OBEventChannelFactory.ChannelNotAvailable();

	return c;
    }

    //
    // Get TypedEventChannel object ids.
    //
    public String[]
    get_channels()
    {
	java.util.Vector v = new java.util.Vector();

  	java.util.Enumeration keys = channels_.keys();
  	while(keys.hasMoreElements())
	    v.addElement((String)keys.nextElement());

  	String[] channelIds = new String[v.size()];
	v.copyInto(channelIds);

	return channelIds;
    }

    //
    // Shutdown the event service.
    //
    synchronized public void
    shutdown()
    {
	if(boa_ != null)
	{
	    ((com.ooc.CORBA.BOA)boa_).deactivate_impl(null);
	    boa_ = null;
	}
    }

    // ------------------------------------------------------------------
    // Internal methods.
    // ------------------------------------------------------------------
    
    //
    // Destroy.
    //
    public void
    destroy()
    {
        //
	// Prevent callbacks to removeChannel() from the event channels'
	// destroy() method.
	//
	java.util.Hashtable channels = channels_;
	channels_ = null;
    
	//
	// Destroy the event channels.
	//
	java.util.Enumeration elements = channels.elements();
	
	while(elements.hasMoreElements())
	{
	    com.ooc.CosEventChannelAdmin.impl.EventChannel c =
		(com.ooc.CosEventChannelAdmin.impl.EventChannel)
		elements.nextElement();
	    if(c != null)
		c.destroy();
	}
    }
    
    //
    // Remove Channel.
    //
    public void
    removeChannel(String id)
    {
	if(channels_ != null)
	{
            //
            // Remove channel.
            //
	    com.ooc.CosTypedEventChannelAdmin.impl.TypedEventChannel c =
		(com.ooc.CosTypedEventChannelAdmin.impl.TypedEventChannel)
		channels_.remove(id);

	    //
	    // If the channel isn't present then this is an internal
	    // error.
	    //
	    if(c == null)
		throw new InternalError();
	}	    
    }
};
