// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package naming;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import java.io.*;
import java.util.*;

public class Client
{
    public static void main(String args[])
    {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass",
                  "com.ooc.CORBA.ORBSingleton");
        System.setProperties(props);

	try
	{
	    //
	    // Create ORB
	    //
            ORB orb = ORB.init(args, props);
	    
	    //
	    // Get naming service
	    //
	    org.omg.CORBA.Object obj = null;
	    
	    try
	    {
		obj = orb.resolve_initial_references("NameService");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		System.err.println("Can't resolve `NameService'");
		System.exit(0);
	    }
	    
	    if(obj == null)
	    {
		System.err.println("`NameService' is a nil object reference");
		System.exit(0);
	    }
	    
	    NamingContext nc = NamingContextHelper.narrow(obj);
	    
	    if(nc == null)
	    {
		System.err.println("`NameService' is not " +
				   "a NamingContext object reference");
		System.exit(0);
	    }
	    
	    //
	    // Get objects by name
	    //
	    try
	    {
		int i;
		
		//
		// Resolve names with the Naming Service
		//
		NameComponent[] aName = new NameComponent[1];
		aName[0] = new NameComponent();
		aName[0].id = "a";
		aName[0].kind = "";
		org.omg.CORBA.Object aObj = nc.resolve(aName);
		Named a = NamedHelper.narrow(aObj);
		if(a == null)
		    throw new RuntimeException();
		System.out.println("Resolved `a'");
		
		NameComponent[] nc1Name = new NameComponent[1];
		nc1Name[0] = new NameComponent();
		nc1Name[0].id = "nc1";
		nc1Name[0].kind = "";
		org.omg.CORBA.Object nc1Obj = nc.resolve(aName);
		Named nc1 = NamedHelper.narrow(nc1Obj);
		if(nc1 == null)
		    throw new RuntimeException();
		System.out.println("Resolved `nc1'");

		NameComponent[] bName = new NameComponent[2];
		bName[0] = new NameComponent();
		bName[0].id = "nc1";
		bName[0].kind = "";
		bName[1] = new NameComponent();
		bName[1].id = "b";
		bName[1].kind = "";
		org.omg.CORBA.Object bObj = nc.resolve(bName);
		Named b = NamedHelper.narrow(bObj);
		if(b == null)
		    throw new RuntimeException();
		System.out.println("Resolved `b' in naming conext `nc1'");

		NameComponent[] nc2Name = new NameComponent[2];
		nc2Name[0] = new NameComponent();
		nc2Name[0].id = "nc1";
		nc2Name[0].kind = "";
		nc2Name[1] = new NameComponent();
		nc2Name[1].id = "nc2";
		nc2Name[1].kind = "";
		org.omg.CORBA.Object nc2Obj = nc.resolve(aName);
		Named nc2 = NamedHelper.narrow(nc2Obj);
		if(nc2 == null)
		    throw new RuntimeException();
		System.out.println("Resolved `nc12' in naming context `nc1'");

		NameComponent[] cName = new NameComponent[3];
		cName[0] = new NameComponent();
		cName[0].id = "nc1";
		cName[0].kind = "";
		cName[1] = new NameComponent();
		cName[1].id = "nc2";
		cName[1].kind = "";
		cName[2] = new NameComponent();
		cName[2].id = "c";
		cName[2].kind = "";
		org.omg.CORBA.Object cObj = nc.resolve(cName);
		Named c = NamedHelper.narrow(cObj);
		if(c == null)
		    throw new RuntimeException();
		System.out.println("Resolved `c' in naming conext `nc2'" +
				   "in naming context  `nc'");

		System.out.println("Listing all bindings:");
		BindingListHolder bl = new BindingListHolder();
		BindingIteratorHolder bi = new BindingIteratorHolder();
		nc.list(999999, bl, bi);
		for(i = 0 ; i < bl.value.length ; i++)
		    printBinding(bl.value[i]);
		if(bi == null)
		    throw new RuntimeException();

		System.out.println("Now listing only two bindings:");
		BindingListHolder bl2 = new BindingListHolder();
		BindingIteratorHolder bi2 = new BindingIteratorHolder();
		nc.list(2, bl2, bi2);
		for(i = 0 ; i < bl2.value.length ; i++)
		    printBinding(bl2.value[i]);
		if(bi2 == null)
		    throw new RuntimeException();

		System.out.println("Listing the rest with the binding "
				   + "iterator:" );
		BindingListHolder bl3 = new BindingListHolder();
		boolean bo = bi2.value.next_n(999999, bl3);
		for(i = 0 ; i < bl3.value.length ; i++)
		    printBinding(bl3.value[i]);
		bi2.value.destroy();
	    }
	    catch(NotFound ex)
	    {
		System.err.print("Got a `NotFound' exception (");
		switch(ex.why.value())
		{
		case NotFoundReason._missing_node:
		    System.err.print("missing node");
		    break;

		case NotFoundReason._not_context:
		    System.err.print("not context");
		    break;

		case NotFoundReason._not_object:
		    System.err.print("not object");
		    break;
		}
		System.err.println(")");
		ex.printStackTrace();
		System.exit(0);
	    }
	    catch(CannotProceed ex)
	    {
		System.err.println("Got a `CannotProceed' exception");
		ex.printStackTrace();
		System.exit(0);
	    }
	    catch(InvalidName ex)
	    {
		System.err.println("Got an `InvalidName' exception");
		ex.printStackTrace();
		System.exit(0);
	    }
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    static void
    printBinding(Binding b)
    {
	int i;

	for(i = 0 ; i < b.binding_name.length ; i++)
	{
	    if(i > 0)
		System.out.print(" ; ");

	    System.out.print(b.binding_name[i].id);
	}

	switch(b.binding_type.value())
	{
	case BindingType._nobject:
	    System.out.println(" (object)");
	    break;

	case BindingType._ncontext:
	    System.out.println(" (context)");
	    break;
	}
    }
}
