// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package naming;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import java.io.*;
import java.util.*;

public class Server
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
	    //
	    // Create ORB
	    //
	    ORB orb = ORB.init(args, props);
	    
	    //
	    // Parse command line arguments
	    //
	    String namingFile = null;
	    int argc = 0;
	    while(argc < args.length)
	    {
		if(args[argc].equals("-f"))
		{
		    if(argc + 1 < args.length)
		    {
			argc++;
			namingFile = args[argc];
		    }
		    else
			usage();
		}
		else if(args[argc].equals("-h") || args[argc].equals("--help"))
		    usage();
		
		argc++;
	    }
	    
	    //
	    // Create BOA
	    //
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);
	    
	    //
	    // Create some implementations
	    //
	    Named a = new Named_impl();
	    Named a1 = new Named_impl();
	    Named a2 = new Named_impl();
	    Named a3 = new Named_impl();
	    Named b = new Named_impl();
	    Named c = new Named_impl();
	    
	    //
	    // Get naming servie
	    //
	    org.omg.CORBA.Object obj = null;

	    if(namingFile != null)
	    {
		try
		{
		    FileReader r = new FileReader(namingFile);
		    BufferedReader in = new BufferedReader(r);
		    String ref = in.readLine();
		    r.close();

		    obj = orb.string_to_object(ref);
		}
		catch(IOException e)
		{
		    e.printStackTrace();
		    System.exit(1);
		}
	    }
	    else
	    {
		try
		{
		    obj = orb.resolve_initial_references("NameService");
		}
		catch(org.omg.CORBA.ORBPackage.InvalidName ex)
		{
		    System.out.println("Can't resolve `NameService'");
		    System.exit(1);
		}
	    }

	    if(obj == null)
	    {
		System.out.println("`NameService' is a nil object reference");
		System.exit(1);
	    }

	    NamingContext nc =
		NamingContextHelper.narrow(obj);

	    if(nc == null)
	    {
		System.out.println("`NameService' is not " +
				   "a NamingContext object reference");
		System.exit(1);
	    }

	    try
	    {
		//
		// Create and bind some Naming Contexts
		//
		NameComponent[] nc1Name = new NameComponent[1];
		nc1Name[0] = new NameComponent();
		nc1Name[0].id = "nc1";
		nc1Name[0].kind = "";
		NamingContext nc1 = nc.bind_new_context(nc1Name);

		NameComponent[] nc2Name = new NameComponent[2];
		nc2Name[0] = new NameComponent();
		nc2Name[0].id = "nc1";
		nc2Name[0].kind = "";
		nc2Name[1] = new NameComponent();
		nc2Name[1].id = "nc2";
		nc2Name[1].kind = "";
		NamingContext nc2 = nc.bind_new_context(nc2Name);

		//
		// Bind names with the Naming Service
		//
		NameComponent[] aName = new NameComponent[1];
		aName[0] = new NameComponent();
		aName[0].id = "a";
		aName[0].kind = "";
		nc.bind(aName, a);

		NameComponent[] a1Name = new NameComponent[1];
		a1Name[0] = new NameComponent();
		a1Name[0].id = "a1";
		a1Name[0].kind = "";
		nc.bind(a1Name, a1);

		NameComponent[] a2Name = new NameComponent[1];
		a2Name[0] = new NameComponent();
		a2Name[0].id = "a2";
		a2Name[0].kind = "";
		nc.bind(a2Name, a2);

		NameComponent[] a3Name = new NameComponent[1];
		a3Name[0] = new NameComponent();
		a3Name[0].id = "a3";
		a3Name[0].kind = "";
		nc.bind(a3Name, a3);

		NameComponent[] bName = new NameComponent[2];
		bName[0] = new NameComponent();
		bName[0].id = "nc1";
		bName[0].kind = "";
		bName[1] = new NameComponent();
		bName[1].id = "b";
		bName[1].kind = "";
		nc.bind(bName, b);

		NameComponent[] cName = new NameComponent[3];
		cName[0] = new NameComponent();
		cName[0].id = "nc1";
		cName[0].kind = "";
		cName[1] = new NameComponent();
		cName[1].id = "nc2";
		cName[1].kind = "";
		cName[2] = new NameComponent();
		cName[2].id = "c";
		cName[2].kind = "";
		nc.bind(cName, c);

		//
		// Run implementation
		//
		boa.impl_is_ready(null);

		//
		// Unregister names with the Naming Service
		//
		nc.unbind(cName);
		nc.unbind(bName);
		nc.unbind(aName);
		nc.unbind(nc2Name);
		nc.unbind(nc1Name);
	    }
	    catch(NotFound ex)
	    {
		System.err.print("Got a `NotFound' exception (");
		switch(ex.why.value())
		{
		case NotFoundReason._missing_node:
		    System.err.print("missing node");
		    break;

		case NotFoundReason._not_context:
		    System.err.print("not context");
		    break;

		case NotFoundReason._not_object:
		    System.err.print("not object");
		    break;
		}
		System.err.println(")");
		ex.printStackTrace();
		System.exit(1);
	    }
	    catch(CannotProceed ex)
	    {
		System.err.println("Got a `CannotProceed' exception");
		ex.printStackTrace();
		System.exit(1);
	    }
	    catch(InvalidName ex)
	    {
		System.err.println("Got an `InvalidName' exception");
		ex.printStackTrace();
		System.exit(1);
	    }
	    catch(AlreadyBound ex)
	    {
		System.err.println("Got an `AlreadyBound' exception");
		ex.printStackTrace();
		System.exit(1);
	    }
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    private static void
    usage()
    {
	System.out.println(
	    "Usage: java naming.Server [options]\n\n" +
	    "Options:\n" +
	    "-f FILE     Read the NamingService IOR from file FILE.\n" +
	    "-h, --help  Display this help message.");

        System.exit(1);
    }
}
 
