// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosNaming;

final class BindingIterator extends org.omg.CosNaming._BindingIteratorImplBase
{
    private org.omg.CORBA.ORB orb_;
    private org.omg.CosNaming.Binding[] bl_;
    private int idx_;

    BindingIterator(org.omg.CORBA.ORB orb, org.omg.CosNaming.Binding[] bl)
    {
	orb_ = orb;
	bl_ = bl;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    synchronized public boolean
    next_one(org.omg.CosNaming.BindingHolder b)
    {
	if(idx_ < bl_.length)
	{
	    b.value = bl_[idx_++];
	    return true;
	}
	else
	{
	    b.value = new org.omg.CosNaming.Binding();
	    b.value.binding_name = new org.omg.CosNaming.NameComponent[0];
	    b.value.binding_type = org.omg.CosNaming.BindingType.nobject;
	    return false;
	}
    }

    synchronized public boolean
    next_n(int how_many, org.omg.CosNaming.BindingListHolder bl)
    {
	if(how_many == 0)
	    throw new org.omg.CORBA.BAD_PARAM();

	int len = bl_.length;
	int num = len - idx_ < how_many ? len - idx_ : how_many;

	bl.value = new org.omg.CosNaming.Binding[num];
	System.arraycopy(bl_, idx_, bl.value, 0, num);
	idx_ += num;

	return num != 0;
    }

    synchronized public void
    destroy()
    {
	orb_.disconnect(this);
    }
}
