// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosNaming;

//
// This class converts ASCII to hex and vice versa
//

final class Converter
{
    //
    // For ASCII to Hex conversion
    //
    final static private String asciiToHex = "0123456789abcdef";

    private Converter()
    {
    }

    //
    // Generate ascii from octet sequence
    //
    public static String
    octetsToAscii(byte[] oct, int count)
    {
	String str = new String();

	if(count > oct.length)
	    throw new InternalError();
	
	for(int i = 0 ; i < count ; i++)
	{
	    str += asciiToHex.charAt((oct[i] >> 4) & 0x0f);
	    str += asciiToHex.charAt(oct[i] & 0x0f);
	}
	
	return str;
    }

    //
    // Generate octet sequence from ascii
    //
    public static byte[]
    asciiToOctets(String str)
    {
	//
	// Two ASCII characters for each octet
	//
	if(str.length() % 2 != 0)
	    return null;

	int len = str.length() / 2;
	byte[] oct = new byte[len];

	str = str.toLowerCase();

	for(int i = 0, j = 0 ; i < len ; i++)
	{
	    int high = asciiToHex.indexOf(str.charAt(j++));
	    int low = asciiToHex.indexOf(str.charAt(j++));

	    //
	    // Check ASCII range (0-9, A-F)
	    //
	    if(high == -1 || low == -1)
		return null;

	    oct[i] = (byte)(16 * high + low);
	}

	return oct;
    }
}
