// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosNaming;

//
// This class is used to update the database journal on a regular
// basis.
//
final class Logger extends Thread
{
    private NamingDatabase store_;

    private int interval_; // Timeout interval
    private boolean stop_;

    Logger(NamingDatabase store, int logSeconds)
    {
	store_ = store;
	interval_ = logSeconds;
    }

    synchronized void
    halt()
    {
	stop_ = true;
	notify();
    }

    synchronized public void
    run()
    {
	while(!stop_)
	{
	    try
	    {
		wait(interval_ * 1000);
	    }
	    catch(InterruptedException ex)
	    {
	    }
	    if(stop_)
		continue;

	    com.ooc.CORBA.MessageViewer.instance().trace(
		2, "Compacting database");

	    store_.updateJournal();
	}
    }
}

