// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosNaming;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

final public class Server
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
	    //
	    // Set the program name.
	    //
	    String progName = "com.ooc.CosNaming.Server";

            //
            // Create ORB.
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Filter options.
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);

	    //
	    // Resolve the service object if available as an initial
	    // reference.
	    //
            String service = "NameService";
            org.omg.CORBA.Object serviceObject = null;
            try
            {
                serviceObject = orb.resolve_initial_references(service);
            }
            catch(org.omg.CORBA.ORBPackage.InvalidName e)
            {
            }

	    //
	    // Set the IIOP port based on the port defined in the IIOP
	    // profile of the service object (if it exists). Then
	    // create the BOA.
	    //
	    com.ooc.CORBA.BOA.set_iiop_port_from_object(serviceObject);
	    com.ooc.CORBA.BOA boa = (com.ooc.CORBA.BOA)
		((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    ((com.ooc.CORBA.ORB)orb).conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelThreaded);
	    //
	    // Ensure the BOA thread model is suitable.  If the BOA
	    // threading model is not thread pool is thread per
	    // request then we force thread per request. The naming
	    // service has to be able to accept callbacks from the
	    // same client therefore thread per client is not
	    // acceptable.
	    //
	    com.ooc.CORBA.BOA.ConcModel model = boa.conc_model();
	    if(model != com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPool &&
	       model != com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerRequest)
	    {
		boa.conc_model(
		    com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerRequest);
	    }

	    //
	    // Filter options
	    //
	    args = ((com.ooc.CORBA.BOA)boa).filter_options(args);

	    //
	    // Get options.
	    //
	    boolean ior = false;
	    boolean noUpdates = false;
	    boolean start = false;
	    int timeout = 5; // Every 5 minutes.
	    String database = null;

	    //
	    // Check properties first.
	    //
	    com.ooc.CORBA.Properties properties =
		com.ooc.CORBA.Properties.instance();
	    String[] keys = properties.getKeys("ooc.naming.");
	    for(int i = 0 ; i < keys.length ; ++i)
	    {
		String key = keys[i];
		String value = properties.getProperty(key);

		if(key.equals("ooc.naming.database"))
		{
		    database = value;
		}
		else if(key.equals("ooc.naming.timeout"))
		{
		    try
		    {
		        timeout = Integer.parseInt(value);
		    }
		    catch(NumberFormatException ex)
		    {
			System.err.println(
			    "Invalid value for ooc.naming.timeout");
			System.exit(1);
		    }
		}
		else if(key.equals("ooc.naming.no_updates"))
		{
		    noUpdates = value.toLowerCase().equals("true") ||
			value.equals("1");
		}
		else
		{
		    System.err.println(progName + ": `" + key + "': " +
				       "unknown property");
		}
	    }

            for(int i = 0 ; i < args.length && args[i].startsWith("-") ; i++)
            {
                if(args[i].equals("--help") ||
                   args[i].equals("-h"))
                {
                    usage(progName);
                    System.exit(0);
                }
                else if(args[i].equals("--version") ||
                        args[i].equals("-v"))
                {
                    System.err.println("Naming Service " +
                                       com.ooc.CORBA.Version.version);
                    System.exit(0);
                }
                else if(args[i].equals("--ior") ||
                        args[i].equals("-i"))
                {
                    ior = true;
                }
                else if(args[i].equals("--no-updates") ||
                        args[i].equals("-n"))
                {
                    noUpdates = true;
                }
		else if(args[i].equals("--timeout") ||
                        args[i].equals("-t"))
                {
                    ++i;
		    if(i >= args.length)
		    {
			System.err.println(progName + ": " + args[i - 1] +
					   "expects argument");
			usage(progName);
			System.exit(1);
		    }

		    timeout = Integer.parseInt(args[i]);
                }
		else if(args[i].equals("--database") ||
                        args[i].equals("-d"))
                {
		    ++i;
		    if(i >= args.length)
		    {
			System.err.println(progName + ": " + args[i - 1] +
					   "expects argument");
			usage(progName);
			System.exit(1);
		    }

		    database = args[i];
		}
		else if(args[i].equals("--start") ||
                        args[i].equals("-s"))
                {
		    start = true;
		}
		else
		{
		    System.err.println(progName + ": unknown option `"
				       + args[i] + "'\n");
		    usage(progName);
		    System.exit(1);
		}
            }

	    if(timeout <= 0)
	    {
		System.err.println(progName + ": timeout value must be > 0");
		System.exit(1);
	    }

	    if(start && database == null)
	    {
		System.err.println(progName +
				   ": --start (-s) requires the the " +
				   "--database (-d) option");
		System.exit(1);
	    }

	    //
	    // Print IOR on standard output.
	    //
	    properties.setProperty("ooc.naming.display_root_ior",
				   (ior) ? "true" : "false");

	    java.util.Hashtable ncs = new java.util.Hashtable(63);
	    NamingDatabase store = null;
	    Logger logger = null;

	    org.omg.CosNaming.NamingContext root = null;

	    if(database != null)
	    {
		//
		// Create a new NamingDatabase.
		//
		store = new NamingDatabase(boa, orb, database, ncs, noUpdates,
					   start);
 
		//
		// Start logger.
		//
		logger = new Logger(store, timeout * 60);
		logger.start();
	    }
	    else
		System.err.println("Running in non-persistent mode.");

	    if(start || database == null)
		root = new com.ooc.CosNaming.NamingContext(
		    orb, store, ncs, "NameService", noUpdates);

            //
            // Run implementation.
            //
            boa.impl_is_ready(null);

	    if(logger != null)
		logger.halt();
 	}
	catch(SystemException ex)
        {
            ex.printStackTrace();
            System.exit(1);
        }

	System.exit(0);
    }

    static void
    usage(String progName)
    {
        System.err.println("Usage:");
        System.err.println(progName + " [options]\n" +
                           "\n" +
                           "Options:\n" +
                           "-h, --help             " +
                           "Show this message.\n" +
                           "-v, --version          " +
                           "Show Naming Service version.\n" +
                           "-i, --ior              " +
                           "Print IOR on standard output.\n" +
			   "-n, --no-updates       " +
			   "No automatic updates with ORBacus Names.\n" +
			   "-s, --start            " +
			   "Run for the first time.\n" +
			   "-d, --database FILE    " +
			   "Use FILE as the database.\n" +
			   "-t, --timeout MINS     " +
			   "Purge the database every MINS minutes.\n" +
			   "                       " +
                           "(The default is 5 minutes.)\n");
    }
}
