// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import java.util.*;
import org.omg.CORBA.*;
import org.omg.CosNaming.*;

public class Client
{
    public static void main(String args[])
    {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass",
                  "com.ooc.CORBA.ORBSingleton");
        System.setProperties(props);

	//
	// Create ORB
	//
	ORB orb = ORB.init(args, props);

	//
	// Create BOA
	//
	BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	//
	// Activate event processing
	//
        ((com.ooc.CORBA.BOA)boa).init_servers();
 
        //
        // Get naming service
        //
        org.omg.CORBA.Object obj = null;
 
        try
        {
            obj = orb.resolve_initial_references("NameService");
        }
        catch(org.omg.CORBA.ORBPackage.InvalidName ex)
        {
            System.err.println("Can't resolve `NameService'");
            System.exit(1);
        }

	if(obj == null)
        {
            System.err.println("`NameService' is a nil object reference");
            System.exit(1);
        }
 
        NamingContextExt nc = NamingContextExtHelper.narrow(obj);
 
        if(nc == null)
        {
            System.err.println("`NameService' is not " +
                               "a NamingContextExt object reference");
            System.exit(1);
        }

	try
	{
	    System.out.print("Testing bind()... ");
	    TestBind.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing rebind()... ");
	    TestRebind.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing bind_context()... ");
	    TestBindContext.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing rebind_context()... ");
	    TestRebindContext.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing resolve()... ");
	    TestResolve.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing unbind()... ");
	    TestUnbind.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing destroy()... ");
	    TestDestroy.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing list()... ");
	    TestList.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing list_extended()... ");
	    TestListExtended.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing rename()... ");
	    TestRename.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing callbacks... ");
	    TestCallbacks.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing to_string()... ");
	    TestToString.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing to_name()... ");
	    TestToName.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing to_url()... ");
	    TestToURL.test(orb, nc);
	    System.out.println("OK!");

	    System.out.print("Testing resolve_str()... ");
	    TestResolveStr.test(orb, nc);
	    System.out.println("OK!");
	}
	catch(UserException ex)
	{
	    throw new RuntimeException();
	}

        System.exit(0);
    }
}
