// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestCallbacks
{
    static void
    WAIT(TestListener_impl listener)
    {
	while(!listener.isValid())
        {
            try
            {
                Thread.sleep(100);
            }
            catch(InterruptedException ex)
            {
            }
        }
    }

    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	com.ooc.CosNaming.OBNamingContext ext =
	    com.ooc.CosNaming.OBNamingContextHelper.narrow(root);
	if(ext == null)
	    throw new RuntimeException();

	if(!ext.callbacks_active())
	    throw new RuntimeException();

	TestListener_impl listener = new TestListener_impl();
	ext.add_listener(listener);

	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;
	NamingContext context;

	//
	// Test BindingListener::object_added
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("name1", "kind1");
	listener.expect(Operation.OBJECT_ADDED, ext, test, name1[0]);
	ext.bind(name1, test);
	WAIT(listener);
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("name2", "kind2");
	listener.expect(Operation.OBJECT_ADDED, ext, test, name2[0]);
	ext.bind(name2, test);
	WAIT(listener);

	//
	// Test BindingListener::object_removed
	//
	listener.expect(Operation.OBJECT_REMOVED, ext, null, name2[0]);
	ext.unbind(name2);
	WAIT(listener);
	listener.expect(Operation.OBJECT_REMOVED, ext, null, name1[0]);
	ext.unbind(name1);
	WAIT(listener);

	//
	// Test BindingListener::object_changed
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("name1", "kind1");
	listener.expect(Operation.OBJECT_ADDED, ext, test, name1[0]);
	ext.bind(name1, test);
	WAIT(listener);
	listener.expect(Operation.OBJECT_CHANGED, ext, null, name1[0]);
	ext.rebind(name1, null);
	WAIT(listener);
	listener.expect(Operation.OBJECT_REMOVED, ext, null, name1[0]);
	ext.unbind(name1);
	WAIT(listener);

	//
	// Test BindingListener::context_added
	//
	context = ext.new_context();
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("context1", "kind1");
	listener.expect(Operation.CONTEXT_ADDED, ext, context, name1[0]);
	ext.bind_context(name1, context);
	WAIT(listener);
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("context2", "kind2");
	listener.expect(Operation.CONTEXT_ADDED, ext, context, name2[0]);
	ext.bind_context(name2, context);
	WAIT(listener);

	//
	// Test BindingListener::context_removed
	//
	listener.expect(Operation.CONTEXT_REMOVED, ext, null, name2[0]);
	ext.unbind(name2);
	WAIT(listener);
	listener.expect(Operation.CONTEXT_REMOVED, ext, null, name1[0]);
	ext.unbind(name1);
	WAIT(listener);

	//
	// Test BindingListener::context_changed
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("context1", "kind1");
	listener.expect(Operation.CONTEXT_ADDED, ext, context, name1[0]);
	ext.bind_context(name1, context);
	WAIT(listener);
	NamingContext ctx = root.new_context();
	listener.expect(Operation.CONTEXT_CHANGED, ext, ctx, name1[0]);
	ext.rebind_context(name1, ctx);
	WAIT(listener);
	listener.expect(Operation.CONTEXT_REMOVED, ext, null, name1[0]);
	ext.unbind(name1);
	WAIT(listener);

	ctx.destroy();
	context.destroy();
 
	ext.remove_listener(listener);
    }
}
