// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestDestroy
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;
	NamingContext context;

	//
	// Test exceptions
	//
 
	context = root.new_context();
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.bind_context(name1, context);
 
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("object", "");
	context.bind(name2, test);

	try
	{
	    //
	    // Try to destroy a context that's not empty
	    //
	    context.destroy();

	    // destroy should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotEmpty ex)
	{
	    // expected
	}
 
	context.unbind(name2);

	//
	// Destroy the context while there is still a binding in the root
	// context.
	//
	context.destroy();
 
	//
	// Ensure that the context has been destroyed.
	//
	try
	{
	    context.unbind(name1);

	    // Call on context should not have succeeded
	    throw new RuntimeException();
	}
	catch(OBJECT_NOT_EXIST ex)
	{
	    // Expected
	}

	//
	// Resolve the context, and attempt a method call.
	//
	org.omg.CORBA.Object obj;
	obj = root.resolve(name1);

	//
	// Ensure that the context has been destroyed.
	//
	try
	{
            NamingContext contextAgain = NamingContextHelper.narrow(obj);
            if(contextAgain == null)
                throw new RuntimeException();

	    contextAgain.unbind(name1);

	    // Call on context should not have succeeded
	    throw new RuntimeException();
	}
	catch(OBJECT_NOT_EXIST ex)
	{
	    // Expected
	}

	//
	// This test should succeed, but doesn't. This is because the
	// context is reconnected implicitely in the naming service.
	// Eventually this test should succeed.
	//
//	if(!context._is_equivalent(contextAgain))
//	    throw new RuntimeException();
 
	//
	// Now unbind.
	//
	root.unbind(name1);
    }
}
