// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestList
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	TestObject test1 = new TestObject_impl();
	TestObject test2 = new TestObject_impl();
	TestObject test3 = new TestObject_impl();
	NameComponent[] name;
	BindingListHolder list = new BindingListHolder();
	BindingIteratorHolder iter = new BindingIteratorHolder();
	BindingHolder binding = new BindingHolder();

	NamingContext context = root.new_context();

	name = new NameComponent[1];
	name[0] = new NameComponent("obj1", "kind1");
	root.bind(name, test1);
	name[0] = new NameComponent("obj2", "kind2");
	root.bind(name, test2);
	name[0] = new NameComponent("obj3", "kind3");
	root.bind(name, test3);
	name[0] = new NameComponent("context", "");
	root.bind_context(name, context);

	root.list(4, list, iter);
	if(list.value.length != 4)
	    throw new RuntimeException();
	if(iter.value != null)
	    throw new RuntimeException();

	for(int i = 0 ; i < list.value.length ; i++)
	{
	    if(list.value[i].binding_name[0].id.equals("obj1") ||
	       list.value[i].binding_name[0].id.equals("obj2") ||
	       list.value[i].binding_name[0].id.equals("obj3"))
	    {
		if(list.value[i].binding_type != BindingType.nobject)
		    throw new RuntimeException();
	    }
	    else if(list.value[i].binding_name[0].id.equals("context"))
	    {
		if(list.value[i].binding_type != BindingType.ncontext)
		    throw new RuntimeException();
	    }
	    else
		// unknown binding in list
		throw new RuntimeException();
	}

	root.list(2, list, iter);
	if(list.value.length != 2)
	    throw new RuntimeException();
	if(iter.value == null)
	    throw new RuntimeException();
	if(!iter.value.next_one(binding))
	    throw new RuntimeException();
	if(!iter.value.next_one(binding))
	    throw new RuntimeException();
	if(iter.value.next_one(binding))
	    throw new RuntimeException(); // no more
	iter.value.destroy();

	root.list(0, list, iter);
	if(list.value.length != 0)
	    throw new RuntimeException();
	if(iter.value == null)
	    throw new RuntimeException();
	if(list.value.length != 0)
	    throw new RuntimeException();
	if(!iter.value.next_n(3, list))
	    throw new RuntimeException();
	if(list.value.length != 3)
	    throw new RuntimeException();
	if(!iter.value.next_n(1, list))
	    throw new RuntimeException();
	if(list.value.length != 1)
	    throw new RuntimeException();
	if(iter.value.next_n(1, list))
	    throw new RuntimeException(); // no more
    	iter.value.destroy();

	//
	// Clean up
	//
	name = new NameComponent[1];
	name[0] = new NameComponent("obj1", "kind1");
	root.unbind(name);
	name[0] = new NameComponent("obj2", "kind2");
	root.unbind(name);
	name[0] = new NameComponent("obj3", "kind3");
	root.unbind(name);
	name[0] = new NameComponent("context", "");
	root.unbind(name);
	context.destroy();
    }
}
