// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestListExtended
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	com.ooc.CosNaming.OBNamingContext ext =
	    com.ooc.CosNaming.OBNamingContextHelper.narrow(root);
	if(ext == null)
	    throw new RuntimeException();

	TestObject test = new TestObject_impl();
	NameComponent[] name1;
	com.ooc.CosNaming.OBNamingContextPackage.ExtendedBinding[] list;

	NamingContext context = ext.new_context();

	//
	// Add some bindings to test list_extended()
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("obj1", "kind1");
	ext.bind(name1, test);
	name1[0].id = "obj2";
	ext.bind(name1, test);
	name1[0].id = "obj3";
	ext.bind(name1, test);
	name1[0].id = "context";
	ext.bind_context(name1, context);

	list = ext.list_extended();
	if(list.length != 4)
	    throw new RuntimeException();

	int tsObj1 = 0, tsObj2 = 0, tsObj3 = 0, tsContext = 0; // timestamps

	//
	// Check BindingType and timestamp
	//
	for(int i = 0 ; i < list.length ; i++)
	{
	    if(list[i].timestamp <= 0)
		throw new RuntimeException();
 
	    //
	    // Remember timestamps
	    //
	    if(list[i].binding_name[0].id.equals("obj1"))
		tsObj1 = list[i].timestamp;
	    else if(list[i].binding_name[0].id.equals("obj2"))
		tsObj2 = list[i].timestamp;
	    else if(list[i].binding_name[0].id.equals("obj3"))
		tsObj3 = list[i].timestamp;
	    else if(list[i].binding_name[0].id.equals("context"))
		tsContext = list[i].timestamp;
 
	    if(list[i].binding_name[0].id.equals("obj1") ||
	       list[i].binding_name[0].id.equals("obj2") ||
	       list[i].binding_name[0].id.equals("obj3"))
	    {
		if(list[i].ncOrObj.discriminator() != BindingType.nobject)
		    throw new RuntimeException();
	    }
	    else if(list[i].binding_name[0].id.equals("context"))
	    {
		if(list[i].ncOrObj.discriminator() != BindingType.ncontext)
		    throw new RuntimeException();
	    }
	    else
		// unknown binding in list
		throw new RuntimeException();
	}

	//
	// Verify timestamps - check order of creation
	//
	if(tsContext < tsObj3 || tsObj3 < tsObj2 || tsObj2 < tsObj1)
	    throw new RuntimeException();
 
	//
	// Remove a binding and test again
	//
	name1[0].id = "obj2";
	ext.unbind(name1);
	list = ext.list_extended();
	if(list.length != 3)
	    throw new RuntimeException();

	//
	// Remove all bindings and test again
	//
	name1[0].id = "obj1";
	ext.unbind(name1);
	name1[0].id = "obj3";
	ext.unbind(name1);
	name1[0].id = "context";
	ext.unbind(name1);
	list = ext.list_extended();
	if(list.length != 0)
	    throw new RuntimeException();

	context.destroy();
    }
}
