// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestListener_impl extends com.ooc.CosNaming._BindingListenerImplBase
{
    private int op_;
    private NamingContext ctx_;
    private org.omg.CORBA.Object obj_;
    private NameComponent name_;
    private boolean valid_;

    TestListener_impl()
    {
	op_ = Operation.OP_NONE;
	ctx_ = null;
	obj_ = null;
	valid_ = false;
    }

    void
    expect(int op, NamingContext ctx, org.omg.CORBA.Object obj,
	   NameComponent name)
    {
	op_ = op;
	ctx_ = ctx;
	obj_= obj;
	name_ = name;
    }

    boolean
    isValid()
    {
	if(valid_)
	{
	    reset();
	    return true;
	}
	else
	    return false;
    }

    //
    // CosNaming::BindingListener operations
    //

    public void
    context_added(NamingContext parent, NamingContext child,
		  NameComponent name)
    {
	validate(Operation.CONTEXT_ADDED, parent, child, name);
    }

    public void
    context_removed(NamingContext parent, NameComponent name)
    {
	validate(Operation.CONTEXT_REMOVED, parent, null, name);
    }

    public void
    context_changed(NamingContext parent, NamingContext child,
		    NameComponent old_name, NameComponent new_name)
    {
	validate(Operation.CONTEXT_CHANGED, parent, child, new_name);
    }

    public void
    object_added(NamingContext parent, org.omg.CORBA.Object child,
		 NameComponent name)
    {
	validate(Operation.OBJECT_ADDED, parent, child, name);
    }

    public void
    object_removed(NamingContext parent, NameComponent name)
    {
	validate(Operation.OBJECT_REMOVED, parent, null, name);
    }

    public void
    object_changed(NamingContext parent, org.omg.CORBA.Object child,
		   NameComponent old_name, NameComponent new_name)
    {
	validate(Operation.OBJECT_CHANGED, parent, child, new_name);
    }

    //
    // Private functions
    //

    private void
    validate(int op, NamingContext ctx, org.omg.CORBA.Object obj,
	     NameComponent name)
    {
	if(op_ != op)
	    throw new RuntimeException();
	// The following assert is wrong, as in some cases ctx_ and
	// ctx are equivalent even though _is_equivalent() returns
	// false.
	//if(!ctx_._is_equivalent(ctx))
	//    throw new RuntimeException();
	if(obj != null)
	{
	    if(!obj_._is_equivalent(obj))
		throw new RuntimeException();
	}
	if(!equal(name_, name))
	    throw new RuntimeException();
	valid_ = true;
    }

    private boolean
    equal(NameComponent n1, NameComponent n2)
    {
	return(n1.id.equals(n2.id) && n1.kind.equals(n2.kind));
    }

    private void
    reset()
    {
	op_ = Operation.OP_NONE;
	valid_ = false;
    }
}
