// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestRebind
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;

	//
	// Test exceptions
	//

	try
	{
	    //
	    // Try to rebind an object when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[2];
	    name1[0] = new NameComponent("bad", "node");
	    name1[1] = new NameComponent("my", "node");
	    root.rebind(name1, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	root.bind(name1, test);

	try
	{
	    //
	    // Try to rebind an object when an object is in the path
	    //
	    name2 = new NameComponent[2];
	    name2[0] = new NameComponent("object", "");
	    name2[1] = new NameComponent("my", "node");
	    root.rebind(name2, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

	//
	// Rebind nil object to name
	//
	root.rebind(name1, null);
	root.unbind(name1);

	try
	{
	    //
	    // Try to rebind an object with an invalid name
	    //
	    name1 = new NameComponent[0];
	    root.rebind(name1, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	try
	{
	    //
	    // Try to rebind an object with an invalid name
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("", "");
	    root.rebind(name1, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	//
	// Bind an intermediate context for use in more tests
	//
	NamingContext context = root.new_context();
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.bind_context(name1, context);

	try
	{
	    //
	    // Try to rebind an object when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[3];
	    name1[0] = new NameComponent("ctx", "");
	    name1[1] = new NameComponent("bad", "node");
	    name1[2] = new NameComponent("my", "node");
	    root.rebind(name1, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	context.bind(name1, test);

	try
	{
	    //
	    // Try to rebind an object when an object is in the path
	    //
	    name2 = new NameComponent[3];
	    name2[0] = new NameComponent("ctx", "");
	    name2[1] = new NameComponent("object", "");
	    name2[2] = new NameComponent("my", "node");
	    root.rebind(name2, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

	//
	// Rebind nil object to an existing name
	//
	name2 = new NameComponent[2];
	name2[0] = new NameComponent("ctx", "");
	name2[1] = new NameComponent("object", "");
	root.rebind(name2, null);
 
	context.unbind(name1);

	try
	{
	    //
	    // Try to rebind an object using the name of an existing context
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("ctx", "");
	    root.rebind(name1, test);

	    // rebind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_object)
		throw new RuntimeException();
	}

	//
	// Clean up context
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.unbind(name1);
	context.destroy();

	//
	// Test name equality to make sure kind is included in comparisons
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "kind1");
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("object", "kind2");
	root.rebind(name1, test);
	root.rebind(name2, test);
	root.unbind(name1);
	root.unbind(name2);
    }
}
